/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsRequest;
import software.amazon.awssdk.services.s3.model.ListMultipartUploadsResponse;
import software.amazon.awssdk.services.s3.model.MultipartUpload;

public class ListMultipartUploadsIterable
implements SdkIterable<ListMultipartUploadsResponse> {
    private final S3Client client;
    private final ListMultipartUploadsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultipartUploadsIterable(S3Client client, ListMultipartUploadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMultipartUploadsResponseFetcher();
    }

    public Iterator<ListMultipartUploadsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<MultipartUpload> uploads() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploads() != null) {
                return response.uploads().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final SdkIterable<CommonPrefix> commonPrefixes() {
        Function<ListMultipartUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.commonPrefixes() != null) {
                return response.commonPrefixes().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListMultipartUploadsIterable resume(ListMultipartUploadsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListMultipartUploadsIterable(this.client, (ListMultipartUploadsRequest)((Object)this.firstRequest.toBuilder().keyMarker(lastSuccessfulPage.nextKeyMarker()).uploadIdMarker(lastSuccessfulPage.nextUploadIdMarker()).build()));
        }
        return new ListMultipartUploadsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListMultipartUploadsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListMultipartUploadsResponseFetcher
    implements SyncPageFetcher<ListMultipartUploadsResponse> {
        private ListMultipartUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartUploadsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public ListMultipartUploadsResponse nextPage(ListMultipartUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartUploadsIterable.this.client.listMultipartUploads(ListMultipartUploadsIterable.this.firstRequest);
            }
            return ListMultipartUploadsIterable.this.client.listMultipartUploads((ListMultipartUploadsRequest)((Object)ListMultipartUploadsIterable.this.firstRequest.toBuilder().keyMarker(previousPage.nextKeyMarker()).uploadIdMarker(previousPage.nextUploadIdMarker()).build()));
        }
    }
}

