/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutObjectResponse
extends S3Response
implements ToCopyableBuilder<Builder, PutObjectResponse> {
    private final String expiration;
    private final String eTag;
    private final String serverSideEncryption;
    private final String versionId;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKeyMD5;
    private final String ssekmsKeyId;
    private final String requestCharged;

    private PutObjectResponse(BuilderImpl builder) {
        super(builder);
        this.expiration = builder.expiration;
        this.eTag = builder.eTag;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.versionId = builder.versionId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.requestCharged = builder.requestCharged;
    }

    public String expiration() {
        return this.expiration;
    }

    public String eTag() {
        return this.eTag;
    }

    public ServerSideEncryption serverSideEncryption() {
        return ServerSideEncryption.fromValue(this.serverSideEncryption);
    }

    public String serverSideEncryptionAsString() {
        return this.serverSideEncryption;
    }

    public String versionId() {
        return this.versionId;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String ssekmsKeyId() {
        return this.ssekmsKeyId;
    }

    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(this.requestCharged);
    }

    public String requestChargedAsString() {
        return this.requestCharged;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssekmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestChargedAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectResponse)) {
            return false;
        }
        PutObjectResponse other = (PutObjectResponse)((Object)obj);
        return Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.serverSideEncryptionAsString(), other.serverSideEncryptionAsString()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.sseCustomerAlgorithm(), other.sseCustomerAlgorithm()) && Objects.equals(this.sseCustomerKeyMD5(), other.sseCustomerKeyMD5()) && Objects.equals(this.ssekmsKeyId(), other.ssekmsKeyId()) && Objects.equals(this.requestChargedAsString(), other.requestChargedAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutObjectResponse").add("Expiration", (Object)this.expiration()).add("ETag", (Object)this.eTag()).add("ServerSideEncryption", (Object)this.serverSideEncryptionAsString()).add("VersionId", (Object)this.versionId()).add("SSECustomerAlgorithm", (Object)this.sseCustomerAlgorithm()).add("SSECustomerKeyMD5", (Object)this.sseCustomerKeyMD5()).add("SSEKMSKeyId", (Object)this.ssekmsKeyId()).add("RequestCharged", (Object)this.requestChargedAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expiration": {
                return Optional.of(clazz.cast(this.expiration()));
            }
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
            case "ServerSideEncryption": {
                return Optional.of(clazz.cast(this.serverSideEncryptionAsString()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "SSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.sseCustomerAlgorithm()));
            }
            case "SSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.sseCustomerKeyMD5()));
            }
            case "SSEKMSKeyId": {
                return Optional.of(clazz.cast(this.ssekmsKeyId()));
            }
            case "RequestCharged": {
                return Optional.of(clazz.cast(this.requestChargedAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private String expiration;
        private String eTag;
        private String serverSideEncryption;
        private String versionId;
        private String sseCustomerAlgorithm;
        private String sseCustomerKeyMD5;
        private String ssekmsKeyId;
        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectResponse model) {
            super(model);
            this.expiration(model.expiration);
            this.eTag(model.eTag);
            this.serverSideEncryption(model.serverSideEncryption);
            this.versionId(model.versionId);
            this.sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            this.sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            this.ssekmsKeyId(model.ssekmsKeyId);
            this.requestCharged(model.requestCharged);
        }

        public final String getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final String getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return this.ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getRequestCharged() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        @Override
        public PutObjectResponse build() {
            return new PutObjectResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, PutObjectResponse> {
        public Builder expiration(String var1);

        public Builder eTag(String var1);

        public Builder serverSideEncryption(String var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder versionId(String var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder ssekmsKeyId(String var1);

        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);
    }
}

