/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.s3.model.AccelerateConfiguration;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutBucketAccelerateConfigurationRequest
extends S3Request
implements ToCopyableBuilder<Builder, PutBucketAccelerateConfigurationRequest> {
    private final String bucket;
    private final AccelerateConfiguration accelerateConfiguration;

    private PutBucketAccelerateConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.accelerateConfiguration = builder.accelerateConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public AccelerateConfiguration accelerateConfiguration() {
        return this.accelerateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.accelerateConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketAccelerateConfigurationRequest)) {
            return false;
        }
        PutBucketAccelerateConfigurationRequest other = (PutBucketAccelerateConfigurationRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.accelerateConfiguration(), other.accelerateConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"PutBucketAccelerateConfigurationRequest").add("Bucket", (Object)this.bucket()).add("AccelerateConfiguration", (Object)this.accelerateConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.of(clazz.cast(this.bucket()));
            }
            case "AccelerateConfiguration": {
                return Optional.of(clazz.cast(this.accelerateConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private AccelerateConfiguration accelerateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketAccelerateConfigurationRequest model) {
            super(model);
            this.bucket(model.bucket);
            this.accelerateConfiguration(model.accelerateConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final AccelerateConfiguration.Builder getAccelerateConfiguration() {
            return this.accelerateConfiguration != null ? this.accelerateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder accelerateConfiguration(AccelerateConfiguration accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
            return this;
        }

        public final void setAccelerateConfiguration(AccelerateConfiguration.BuilderImpl accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration != null ? accelerateConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutBucketAccelerateConfigurationRequest build() {
            return new PutBucketAccelerateConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    CopyableBuilder<Builder, PutBucketAccelerateConfigurationRequest> {
        public Builder bucket(String var1);

        public Builder accelerateConfiguration(AccelerateConfiguration var1);

        default public Builder accelerateConfiguration(Consumer<AccelerateConfiguration.Builder> accelerateConfiguration) {
            return this.accelerateConfiguration((AccelerateConfiguration)((AccelerateConfiguration.Builder)AccelerateConfiguration.builder().apply(accelerateConfiguration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

