/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.TransitionStorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NoncurrentVersionTransition
implements ToCopyableBuilder<Builder, NoncurrentVersionTransition> {
    private final Integer noncurrentDays;
    private final String storageClass;

    private NoncurrentVersionTransition(BuilderImpl builder) {
        this.noncurrentDays = builder.noncurrentDays;
        this.storageClass = builder.storageClass;
    }

    public Integer noncurrentDays() {
        return this.noncurrentDays;
    }

    public TransitionStorageClass storageClass() {
        return TransitionStorageClass.fromValue(this.storageClass);
    }

    public String storageClassAsString() {
        return this.storageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.noncurrentDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoncurrentVersionTransition)) {
            return false;
        }
        NoncurrentVersionTransition other = (NoncurrentVersionTransition)obj;
        return Objects.equals(this.noncurrentDays(), other.noncurrentDays()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString());
    }

    public String toString() {
        return ToString.builder((String)"NoncurrentVersionTransition").add("NoncurrentDays", (Object)this.noncurrentDays()).add("StorageClass", (Object)this.storageClassAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NoncurrentDays": {
                return Optional.of(clazz.cast(this.noncurrentDays()));
            }
            case "StorageClass": {
                return Optional.of(clazz.cast(this.storageClassAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer noncurrentDays;
        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(NoncurrentVersionTransition model) {
            this.noncurrentDays(model.noncurrentDays);
            this.storageClass(model.storageClass);
        }

        public final Integer getNoncurrentDays() {
            return this.noncurrentDays;
        }

        @Override
        public final Builder noncurrentDays(Integer noncurrentDays) {
            this.noncurrentDays = noncurrentDays;
            return this;
        }

        public final void setNoncurrentDays(Integer noncurrentDays) {
            this.noncurrentDays = noncurrentDays;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(TransitionStorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public NoncurrentVersionTransition build() {
            return new NoncurrentVersionTransition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NoncurrentVersionTransition> {
        public Builder noncurrentDays(Integer var1);

        public Builder storageClass(String var1);

        public Builder storageClass(TransitionStorageClass var1);
    }
}

