/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.Payer;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketRequestPaymentResponse
extends S3Response
implements ToCopyableBuilder<Builder, GetBucketRequestPaymentResponse> {
    private final String payer;

    private GetBucketRequestPaymentResponse(BuilderImpl builder) {
        super(builder);
        this.payer = builder.payer;
    }

    public Payer payer() {
        return Payer.fromValue(this.payer);
    }

    public String payerAsString() {
        return this.payer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payerAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketRequestPaymentResponse)) {
            return false;
        }
        GetBucketRequestPaymentResponse other = (GetBucketRequestPaymentResponse)((Object)obj);
        return Objects.equals(this.payerAsString(), other.payerAsString());
    }

    public String toString() {
        return ToString.builder((String)"GetBucketRequestPaymentResponse").add("Payer", (Object)this.payerAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Payer": {
                return Optional.of(clazz.cast(this.payerAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private String payer;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketRequestPaymentResponse model) {
            super(model);
            this.payer(model.payer);
        }

        public final String getPayer() {
            return this.payer;
        }

        @Override
        public final Builder payer(String payer) {
            this.payer = payer;
            return this;
        }

        @Override
        public final Builder payer(Payer payer) {
            this.payer(payer.toString());
            return this;
        }

        public final void setPayer(String payer) {
            this.payer = payer;
        }

        @Override
        public GetBucketRequestPaymentResponse build() {
            return new GetBucketRequestPaymentResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, GetBucketRequestPaymentResponse> {
        public Builder payer(String var1);

        public Builder payer(Payer var1);
    }
}

