/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.s3.model.LifecycleRule;
import software.amazon.awssdk.services.s3.model.LifecycleRulesCopier;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketLifecycleConfigurationResponse
extends S3Response
implements ToCopyableBuilder<Builder, GetBucketLifecycleConfigurationResponse> {
    private final List<LifecycleRule> rules;

    private GetBucketLifecycleConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.rules = builder.rules;
    }

    public List<LifecycleRule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketLifecycleConfigurationResponse)) {
            return false;
        }
        GetBucketLifecycleConfigurationResponse other = (GetBucketLifecycleConfigurationResponse)((Object)obj);
        return Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"GetBucketLifecycleConfigurationResponse").add("Rules", this.rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rules": {
                return Optional.of(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private List<LifecycleRule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketLifecycleConfigurationResponse model) {
            super(model);
            this.rules(model.rules);
        }

        public final Collection<LifecycleRule.Builder> getRules() {
            return this.rules != null ? (Collection)this.rules.stream().map(LifecycleRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<LifecycleRule> rules) {
            this.rules = LifecycleRulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(LifecycleRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<LifecycleRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (LifecycleRule)((LifecycleRule.Builder)LifecycleRule.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<LifecycleRule.BuilderImpl> rules) {
            this.rules = LifecycleRulesCopier.copyFromBuilder(rules);
        }

        @Override
        public GetBucketLifecycleConfigurationResponse build() {
            return new GetBucketLifecycleConfigurationResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, GetBucketLifecycleConfigurationResponse> {
        public Builder rules(Collection<LifecycleRule> var1);

        public Builder rules(LifecycleRule ... var1);

        public Builder rules(Consumer<LifecycleRule.Builder> ... var1);
    }
}

