/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.s3.model.Grant;
import software.amazon.awssdk.services.s3.model.GrantsCopier;
import software.amazon.awssdk.services.s3.model.Owner;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetBucketAclResponse
extends S3Response
implements ToCopyableBuilder<Builder, GetBucketAclResponse> {
    private final Owner owner;
    private final List<Grant> grants;

    private GetBucketAclResponse(BuilderImpl builder) {
        super(builder);
        this.owner = builder.owner;
        this.grants = builder.grants;
    }

    public Owner owner() {
        return this.owner;
    }

    public List<Grant> grants() {
        return this.grants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.grants());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketAclResponse)) {
            return false;
        }
        GetBucketAclResponse other = (GetBucketAclResponse)((Object)obj);
        return Objects.equals(this.owner(), other.owner()) && Objects.equals(this.grants(), other.grants());
    }

    public String toString() {
        return ToString.builder((String)"GetBucketAclResponse").add("Owner", (Object)this.owner()).add("Grants", this.grants()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "Grants": {
                return Optional.of(clazz.cast(this.grants()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private Owner owner;
        private List<Grant> grants;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketAclResponse model) {
            super(model);
            this.owner(model.owner);
            this.grants(model.grants);
        }

        public final Owner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final Collection<Grant.Builder> getGrants() {
            return this.grants != null ? (Collection)this.grants.stream().map(Grant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder grants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Grant ... grants) {
            this.grants(Arrays.asList(grants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Consumer<Grant.Builder> ... grants) {
            this.grants(Stream.of(grants).map(c -> (Grant)((Grant.Builder)Grant.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGrants(Collection<Grant.BuilderImpl> grants) {
            this.grants = GrantsCopier.copyFromBuilder(grants);
        }

        @Override
        public GetBucketAclResponse build() {
            return new GetBucketAclResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, GetBucketAclResponse> {
        public Builder owner(Owner var1);

        default public Builder owner(Consumer<Owner.Builder> owner) {
            return this.owner((Owner)((Owner.Builder)Owner.builder().apply(owner)).build());
        }

        public Builder grants(Collection<Grant> var1);

        public Builder grants(Grant ... var1);

        public Builder grants(Consumer<Grant.Builder> ... var1);
    }
}

