/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.NotificationConfiguration;
import software.amazon.awssdk.services.s3.transform.LambdaFunctionConfigurationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.QueueConfigurationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.TopicConfigurationUnmarshaller;

public class NotificationConfigurationUnmarshaller
implements Unmarshaller<NotificationConfiguration, StaxUnmarshallerContext> {
    private static NotificationConfigurationUnmarshaller INSTANCE;

    public NotificationConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NotificationConfiguration.Builder notificationConfiguration = NotificationConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("TopicConfiguration", targetDepth)) {
                    notificationConfiguration.topicConfigurations(TopicConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("QueueConfiguration", targetDepth)) {
                    notificationConfiguration.queueConfigurations(QueueConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CloudFunctionConfiguration", targetDepth)) continue;
                notificationConfiguration.lambdaFunctionConfigurations(LambdaFunctionConfigurationUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NotificationConfiguration)notificationConfiguration.build();
    }

    public static NotificationConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NotificationConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

