/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.transform.BucketUnmarshaller;
import software.amazon.awssdk.services.s3.transform.OwnerUnmarshaller;

public class ListBucketsResponseUnmarshaller
implements Unmarshaller<ListBucketsResponse, StaxUnmarshallerContext> {
    private static ListBucketsResponseUnmarshaller INSTANCE;

    public ListBucketsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ListBucketsResponse.Builder listBucketsResponse = ListBucketsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Buckets", targetDepth)) {
                    listBucketsResponse.buckets(new ArrayList<Bucket>());
                    continue;
                }
                if (context.testExpression("Buckets/Bucket", targetDepth)) {
                    listBucketsResponse.buckets(BucketUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Owner", targetDepth)) continue;
                listBucketsResponse.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ListBucketsResponse)((Object)listBucketsResponse.build());
    }

    public static ListBucketsResponseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ListBucketsResponseUnmarshaller();
        }
        return INSTANCE;
    }
}

