/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration;
import software.amazon.awssdk.services.s3.transform.NotificationConfigurationFilterUnmarshaller;

public class LambdaFunctionConfigurationUnmarshaller
implements Unmarshaller<LambdaFunctionConfiguration, StaxUnmarshallerContext> {
    private static LambdaFunctionConfigurationUnmarshaller INSTANCE;

    public LambdaFunctionConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LambdaFunctionConfiguration.Builder lambdaFunctionConfiguration = LambdaFunctionConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    lambdaFunctionConfiguration.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CloudFunction", targetDepth)) {
                    lambdaFunctionConfiguration.lambdaFunctionArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Event", targetDepth)) {
                    lambdaFunctionConfiguration.events(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Filter", targetDepth)) continue;
                lambdaFunctionConfiguration.filter(NotificationConfigurationFilterUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LambdaFunctionConfiguration)lambdaFunctionConfiguration.build();
    }

    public static LambdaFunctionConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LambdaFunctionConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

