/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.IndexDocument;

public class IndexDocumentUnmarshaller
implements Unmarshaller<IndexDocument, StaxUnmarshallerContext> {
    private static IndexDocumentUnmarshaller INSTANCE;

    public IndexDocument unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        IndexDocument.Builder indexDocument = IndexDocument.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("Suffix", targetDepth)) continue;
                indexDocument.suffix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (IndexDocument)indexDocument.build();
    }

    public static IndexDocumentUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IndexDocumentUnmarshaller();
        }
        return INSTANCE;
    }
}

