/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.DeleteBucketWebsiteRequest;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class DeleteBucketWebsiteRequestMarshaller
implements Marshaller<Request<DeleteBucketWebsiteRequest>, DeleteBucketWebsiteRequest> {
    public Request<DeleteBucketWebsiteRequest> marshall(DeleteBucketWebsiteRequest deleteBucketWebsiteRequest) {
        if (deleteBucketWebsiteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteBucketWebsiteRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?website";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketWebsiteRequest.bucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

