/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.util.UriResourcePathUtils;

public class CreateMultipartUploadRequestMarshaller
implements Marshaller<Request<CreateMultipartUploadRequest>, CreateMultipartUploadRequest> {
    public Request<CreateMultipartUploadRequest> marshall(CreateMultipartUploadRequest createMultipartUploadRequest) {
        if (createMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createMultipartUploadRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.POST);
        if (createMultipartUploadRequest.acl() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString((String)createMultipartUploadRequest.acl()));
        }
        if (createMultipartUploadRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringUtils.fromString((String)createMultipartUploadRequest.cacheControl()));
        }
        if (createMultipartUploadRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringUtils.fromString((String)createMultipartUploadRequest.contentDisposition()));
        }
        if (createMultipartUploadRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringUtils.fromString((String)createMultipartUploadRequest.contentEncoding()));
        }
        if (createMultipartUploadRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringUtils.fromString((String)createMultipartUploadRequest.contentLanguage()));
        }
        if (createMultipartUploadRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString((String)createMultipartUploadRequest.contentType()));
        }
        if (createMultipartUploadRequest.expires() != null) {
            request.addHeader("Expires", StringUtils.fromDate((Date)createMultipartUploadRequest.expires()));
        }
        if (createMultipartUploadRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString((String)createMultipartUploadRequest.grantFullControl()));
        }
        if (createMultipartUploadRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString((String)createMultipartUploadRequest.grantRead()));
        }
        if (createMultipartUploadRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString((String)createMultipartUploadRequest.grantReadACP()));
        }
        if (createMultipartUploadRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString((String)createMultipartUploadRequest.grantWriteACP()));
        }
        if (createMultipartUploadRequest.serverSideEncryption() != null) {
            request.addHeader("x-amz-server-side-encryption", StringUtils.fromString((String)createMultipartUploadRequest.serverSideEncryption()));
        }
        if (createMultipartUploadRequest.storageClass() != null) {
            request.addHeader("x-amz-storage-class", StringUtils.fromString((String)createMultipartUploadRequest.storageClass()));
        }
        if (createMultipartUploadRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", StringUtils.fromString((String)createMultipartUploadRequest.websiteRedirectLocation()));
        }
        if (createMultipartUploadRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm", StringUtils.fromString((String)createMultipartUploadRequest.sseCustomerAlgorithm()));
        }
        if (createMultipartUploadRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key", StringUtils.fromString((String)createMultipartUploadRequest.sseCustomerKey()));
        }
        if (createMultipartUploadRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", StringUtils.fromString((String)createMultipartUploadRequest.sseCustomerKeyMD5()));
        }
        if (createMultipartUploadRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id", StringUtils.fromString((String)createMultipartUploadRequest.ssekmsKeyId()));
        }
        if (createMultipartUploadRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString((String)createMultipartUploadRequest.requestPayer()));
        }
        if (createMultipartUploadRequest.metadata() != null) {
            createMultipartUploadRequest.metadata().entrySet().forEach(arg_0 -> CreateMultipartUploadRequestMarshaller.lambda$marshall$0((Request)request, arg_0));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?uploads";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", createMultipartUploadRequest.bucket());
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "Key", createMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        request.addHeader("Content-Length", String.valueOf(0));
        return request;
    }

    private static /* synthetic */ void lambda$marshall$0(Request request, Map.Entry e) {
        if (((String)e.getKey()).startsWith("x-amz-meta-")) {
            request.addHeader((String)e.getKey(), (String)e.getValue());
        } else {
            request.addHeader("x-amz-meta-" + (String)e.getKey(), (String)e.getValue());
        }
    }
}

