/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CopyObjectResult;

public class CopyObjectResultUnmarshaller
implements Unmarshaller<CopyObjectResult, StaxUnmarshallerContext> {
    private static CopyObjectResultUnmarshaller INSTANCE;

    public CopyObjectResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        CopyObjectResult.Builder copyObjectResult = CopyObjectResult.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ETag", targetDepth)) {
                    copyObjectResult.eTag(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("LastModified", targetDepth)) continue;
                copyObjectResult.lastModified(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (CopyObjectResult)copyObjectResult.build();
    }

    public static CopyObjectResultUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CopyObjectResultUnmarshaller();
        }
        return INSTANCE;
    }
}

