/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.RestoreRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreObjectRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, RestoreObjectRequest> {
    private final String bucket;
    private final String key;
    private final String versionId;
    private final RestoreRequest restoreRequest;
    private final String requestPayer;

    private RestoreObjectRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.restoreRequest = builder.restoreRequest;
        this.requestPayer = builder.requestPayer;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String versionId() {
        return this.versionId;
    }

    public RestoreRequest restoreRequest() {
        return this.restoreRequest;
    }

    public String requestPayer() {
        return this.requestPayer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bucket() == null ? 0 : this.bucket().hashCode());
        hashCode = 31 * hashCode + (this.key() == null ? 0 : this.key().hashCode());
        hashCode = 31 * hashCode + (this.versionId() == null ? 0 : this.versionId().hashCode());
        hashCode = 31 * hashCode + (this.restoreRequest() == null ? 0 : this.restoreRequest().hashCode());
        hashCode = 31 * hashCode + (this.requestPayer() == null ? 0 : this.requestPayer().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreObjectRequest)) {
            return false;
        }
        RestoreObjectRequest other = (RestoreObjectRequest)((Object)obj);
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.restoreRequest() == null ^ this.restoreRequest() == null) {
            return false;
        }
        if (other.restoreRequest() != null && !other.restoreRequest().equals(this.restoreRequest())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        return other.requestPayer() == null || other.requestPayer().equals(this.requestPayer());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bucket() != null) {
            sb.append("Bucket: ").append(this.bucket()).append(",");
        }
        if (this.key() != null) {
            sb.append("Key: ").append(this.key()).append(",");
        }
        if (this.versionId() != null) {
            sb.append("VersionId: ").append(this.versionId()).append(",");
        }
        if (this.restoreRequest() != null) {
            sb.append("RestoreRequest: ").append(this.restoreRequest()).append(",");
        }
        if (this.requestPayer() != null) {
            sb.append("RequestPayer: ").append(this.requestPayer()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String key;
        private String versionId;
        private RestoreRequest restoreRequest;
        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreObjectRequest model) {
            this.setBucket(model.bucket);
            this.setKey(model.key);
            this.setVersionId(model.versionId);
            this.setRestoreRequest(model.restoreRequest);
            this.setRequestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final RestoreRequest getRestoreRequest() {
            return this.restoreRequest;
        }

        @Override
        public final Builder restoreRequest(RestoreRequest restoreRequest) {
            this.restoreRequest = restoreRequest;
            return this;
        }

        public final void setRestoreRequest(RestoreRequest restoreRequest) {
            this.restoreRequest = restoreRequest;
        }

        public final String getRequestPayer() {
            return this.requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final void setRequestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
        }

        public RestoreObjectRequest build() {
            return new RestoreObjectRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreObjectRequest> {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder versionId(String var1);

        public Builder restoreRequest(RestoreRequest var1);

        public Builder requestPayer(String var1);

        public Builder requestPayer(RequestPayer var1);
    }
}

