/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.services.s3.model.Protocol;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Redirect
implements ToCopyableBuilder<Builder, Redirect> {
    private final String hostName;
    private final String httpRedirectCode;
    private final String protocol;
    private final String replaceKeyPrefixWith;
    private final String replaceKeyWith;

    private Redirect(BuilderImpl builder) {
        this.hostName = builder.hostName;
        this.httpRedirectCode = builder.httpRedirectCode;
        this.protocol = builder.protocol;
        this.replaceKeyPrefixWith = builder.replaceKeyPrefixWith;
        this.replaceKeyWith = builder.replaceKeyWith;
    }

    public String hostName() {
        return this.hostName;
    }

    public String httpRedirectCode() {
        return this.httpRedirectCode;
    }

    public String protocol() {
        return this.protocol;
    }

    public String replaceKeyPrefixWith() {
        return this.replaceKeyPrefixWith;
    }

    public String replaceKeyWith() {
        return this.replaceKeyWith;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.hostName() == null ? 0 : this.hostName().hashCode());
        hashCode = 31 * hashCode + (this.httpRedirectCode() == null ? 0 : this.httpRedirectCode().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.replaceKeyPrefixWith() == null ? 0 : this.replaceKeyPrefixWith().hashCode());
        hashCode = 31 * hashCode + (this.replaceKeyWith() == null ? 0 : this.replaceKeyWith().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Redirect)) {
            return false;
        }
        Redirect other = (Redirect)obj;
        if (other.hostName() == null ^ this.hostName() == null) {
            return false;
        }
        if (other.hostName() != null && !other.hostName().equals(this.hostName())) {
            return false;
        }
        if (other.httpRedirectCode() == null ^ this.httpRedirectCode() == null) {
            return false;
        }
        if (other.httpRedirectCode() != null && !other.httpRedirectCode().equals(this.httpRedirectCode())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.replaceKeyPrefixWith() == null ^ this.replaceKeyPrefixWith() == null) {
            return false;
        }
        if (other.replaceKeyPrefixWith() != null && !other.replaceKeyPrefixWith().equals(this.replaceKeyPrefixWith())) {
            return false;
        }
        if (other.replaceKeyWith() == null ^ this.replaceKeyWith() == null) {
            return false;
        }
        return other.replaceKeyWith() == null || other.replaceKeyWith().equals(this.replaceKeyWith());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostName() != null) {
            sb.append("HostName: ").append(this.hostName()).append(",");
        }
        if (this.httpRedirectCode() != null) {
            sb.append("HttpRedirectCode: ").append(this.httpRedirectCode()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.replaceKeyPrefixWith() != null) {
            sb.append("ReplaceKeyPrefixWith: ").append(this.replaceKeyPrefixWith()).append(",");
        }
        if (this.replaceKeyWith() != null) {
            sb.append("ReplaceKeyWith: ").append(this.replaceKeyWith()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String hostName;
        private String httpRedirectCode;
        private String protocol;
        private String replaceKeyPrefixWith;
        private String replaceKeyWith;

        private BuilderImpl() {
        }

        private BuilderImpl(Redirect model) {
            this.setHostName(model.hostName);
            this.setHttpRedirectCode(model.httpRedirectCode);
            this.setProtocol(model.protocol);
            this.setReplaceKeyPrefixWith(model.replaceKeyPrefixWith);
            this.setReplaceKeyWith(model.replaceKeyWith);
        }

        public final String getHostName() {
            return this.hostName;
        }

        @Override
        public final Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public final void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public final String getHttpRedirectCode() {
            return this.httpRedirectCode;
        }

        @Override
        public final Builder httpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
            return this;
        }

        public final void setHttpRedirectCode(String httpRedirectCode) {
            this.httpRedirectCode = httpRedirectCode;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(Protocol protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final void setProtocol(Protocol protocol) {
            this.protocol(protocol.toString());
        }

        public final String getReplaceKeyPrefixWith() {
            return this.replaceKeyPrefixWith;
        }

        @Override
        public final Builder replaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
            return this;
        }

        public final void setReplaceKeyPrefixWith(String replaceKeyPrefixWith) {
            this.replaceKeyPrefixWith = replaceKeyPrefixWith;
        }

        public final String getReplaceKeyWith() {
            return this.replaceKeyWith;
        }

        @Override
        public final Builder replaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
            return this;
        }

        public final void setReplaceKeyWith(String replaceKeyWith) {
            this.replaceKeyWith = replaceKeyWith;
        }

        public Redirect build() {
            return new Redirect(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Redirect> {
        public Builder hostName(String var1);

        public Builder httpRedirectCode(String var1);

        public Builder protocol(String var1);

        public Builder protocol(Protocol var1);

        public Builder replaceKeyPrefixWith(String var1);

        public Builder replaceKeyWith(String var1);
    }
}

