/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum ObjectStorageClass {
    STANDARD("STANDARD"),
    REDUCED_REDUNDANCY("REDUCED_REDUNDANCY"),
    GLACIER("GLACIER");

    private final String value;

    private ObjectStorageClass(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ObjectStorageClass fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(ObjectStorageClass.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

