/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.services.s3.model.MetricsAndOperator;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricsFilter
implements ToCopyableBuilder<Builder, MetricsFilter> {
    private final String prefix;
    private final Tag tag;
    private final MetricsAndOperator and;

    private MetricsFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.and = builder.and;
    }

    public String prefix() {
        return this.prefix;
    }

    public Tag tag() {
        return this.tag;
    }

    public MetricsAndOperator and() {
        return this.and;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.prefix() == null ? 0 : this.prefix().hashCode());
        hashCode = 31 * hashCode + (this.tag() == null ? 0 : this.tag().hashCode());
        hashCode = 31 * hashCode + (this.and() == null ? 0 : this.and().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricsFilter)) {
            return false;
        }
        MetricsFilter other = (MetricsFilter)obj;
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.tag() == null ^ this.tag() == null) {
            return false;
        }
        if (other.tag() != null && !other.tag().equals(this.tag())) {
            return false;
        }
        if (other.and() == null ^ this.and() == null) {
            return false;
        }
        return other.and() == null || other.and().equals(this.and());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.prefix() != null) {
            sb.append("Prefix: ").append(this.prefix()).append(",");
        }
        if (this.tag() != null) {
            sb.append("Tag: ").append(this.tag()).append(",");
        }
        if (this.and() != null) {
            sb.append("And: ").append(this.and()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String prefix;
        private Tag tag;
        private MetricsAndOperator and;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricsFilter model) {
            this.setPrefix(model.prefix);
            this.setTag(model.tag);
            this.setAnd(model.and);
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final Tag getTag() {
            return this.tag;
        }

        @Override
        public final Builder tag(Tag tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(Tag tag) {
            this.tag = tag;
        }

        public final MetricsAndOperator getAnd() {
            return this.and;
        }

        @Override
        public final Builder and(MetricsAndOperator and) {
            this.and = and;
            return this;
        }

        public final void setAnd(MetricsAndOperator and) {
            this.and = and;
        }

        public MetricsFilter build() {
            return new MetricsFilter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricsFilter> {
        public Builder prefix(String var1);

        public Builder tag(Tag var1);

        public Builder and(MetricsAndOperator var1);
    }
}

