/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringUtils;

/**
 * GetObjectTorrentRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetObjectTorrentRequestMarshaller implements Marshaller<Request<GetObjectTorrentRequest>, GetObjectTorrentRequest> {

    public Request<GetObjectTorrentRequest> marshall(GetObjectTorrentRequest getObjectTorrentRequest) {

        if (getObjectTorrentRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetObjectTorrentRequest> request = new DefaultRequest<GetObjectTorrentRequest>(getObjectTorrentRequest,
                "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        if (getObjectTorrentRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(getObjectTorrentRequest.requestPayer()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}?torrent";

        uriResourcePath = software.amazon.awssdk.util.UriResourcePathUtils.addStaticQueryParamtersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                getObjectTorrentRequest.bucket());
        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                getObjectTorrentRequest.key());
        request.setResourcePath(uriResourcePath);

        return request;
    }

}