/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

import software.amazon.awssdk.util.StringUtils;

/**
 * GetObjectRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetObjectRequestMarshaller implements Marshaller<Request<GetObjectRequest>, GetObjectRequest> {

    public Request<GetObjectRequest> marshall(GetObjectRequest getObjectRequest) {

        if (getObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<GetObjectRequest> request = new DefaultRequest<GetObjectRequest>(getObjectRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        if (getObjectRequest.ifMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(getObjectRequest.ifMatch()));
        }

        if (getObjectRequest.ifModifiedSince() != null) {
            request.addHeader("If-Modified-Since", StringUtils.fromDate(getObjectRequest.ifModifiedSince()));
        }

        if (getObjectRequest.ifNoneMatch() != null) {
            request.addHeader("If-None-Match", StringUtils.fromString(getObjectRequest.ifNoneMatch()));
        }

        if (getObjectRequest.ifUnmodifiedSince() != null) {
            request.addHeader("If-Unmodified-Since", StringUtils.fromDate(getObjectRequest.ifUnmodifiedSince()));
        }

        if (getObjectRequest.range() != null) {
            request.addHeader("Range", StringUtils.fromString(getObjectRequest.range()));
        }

        if (getObjectRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringUtils.fromString(getObjectRequest.sseCustomerAlgorithm()));
        }

        if (getObjectRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringUtils.fromString(getObjectRequest.sseCustomerKey()));
        }

        if (getObjectRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringUtils.fromString(getObjectRequest.sseCustomerKeyMD5()));
        }

        if (getObjectRequest.requestPayer() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(getObjectRequest.requestPayer()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                getObjectRequest.bucket());
        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                getObjectRequest.key());
        request.setResourcePath(uriResourcePath);

        if (getObjectRequest.responseCacheControl() != null) {
            request.addParameter("response-cache-control", StringUtils.fromString(getObjectRequest.responseCacheControl()));
        }

        if (getObjectRequest.responseContentDisposition() != null) {
            request.addParameter("response-content-disposition",
                    StringUtils.fromString(getObjectRequest.responseContentDisposition()));
        }

        if (getObjectRequest.responseContentEncoding() != null) {
            request.addParameter("response-content-encoding", StringUtils.fromString(getObjectRequest.responseContentEncoding()));
        }

        if (getObjectRequest.responseContentLanguage() != null) {
            request.addParameter("response-content-language", StringUtils.fromString(getObjectRequest.responseContentLanguage()));
        }

        if (getObjectRequest.responseContentType() != null) {
            request.addParameter("response-content-type", StringUtils.fromString(getObjectRequest.responseContentType()));
        }

        if (getObjectRequest.responseExpires() != null) {
            request.addParameter("response-expires", StringUtils.fromDate(getObjectRequest.responseExpires()));
        }

        if (getObjectRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(getObjectRequest.versionId()));
        }

        if (getObjectRequest.partNumber() != null) {
            request.addParameter("partNumber", StringUtils.fromInteger(getObjectRequest.partNumber()));
        }

        return request;
    }

}