/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;

/**
 * DeleteBucketWebsiteRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteBucketWebsiteRequestMarshaller implements
        Marshaller<Request<DeleteBucketWebsiteRequest>, DeleteBucketWebsiteRequest> {

    public Request<DeleteBucketWebsiteRequest> marshall(DeleteBucketWebsiteRequest deleteBucketWebsiteRequest) {

        if (deleteBucketWebsiteRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteBucketWebsiteRequest> request = new DefaultRequest<DeleteBucketWebsiteRequest>(deleteBucketWebsiteRequest,
                "S3Client");

        request.setHttpMethod(HttpMethodName.DELETE);

        String uriResourcePath = "/{Bucket}?website";

        uriResourcePath = software.amazon.awssdk.util.UriResourcePathUtils.addStaticQueryParamtersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket",
                deleteBucketWebsiteRequest.bucket());
        request.setResourcePath(uriResourcePath);

        return request;
    }

}