/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class WebsiteConfiguration implements ToCopyableBuilder<WebsiteConfiguration.Builder, WebsiteConfiguration> {
    private final ErrorDocument errorDocument;

    private final IndexDocument indexDocument;

    private final RedirectAllRequestsTo redirectAllRequestsTo;

    private final List<RoutingRule> routingRules;

    private WebsiteConfiguration(BuilderImpl builder) {
        this.errorDocument = builder.errorDocument;
        this.indexDocument = builder.indexDocument;
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.routingRules = builder.routingRules;
    }

    /**
     *
     * @return
     */
    public ErrorDocument errorDocument() {
        return errorDocument;
    }

    /**
     *
     * @return
     */
    public IndexDocument indexDocument() {
        return indexDocument;
    }

    /**
     *
     * @return
     */
    public RedirectAllRequestsTo redirectAllRequestsTo() {
        return redirectAllRequestsTo;
    }

    /**
     *
     * @return
     */
    public List<RoutingRule> routingRules() {
        return routingRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((errorDocument() == null) ? 0 : errorDocument().hashCode());
        hashCode = 31 * hashCode + ((indexDocument() == null) ? 0 : indexDocument().hashCode());
        hashCode = 31 * hashCode + ((redirectAllRequestsTo() == null) ? 0 : redirectAllRequestsTo().hashCode());
        hashCode = 31 * hashCode + ((routingRules() == null) ? 0 : routingRules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebsiteConfiguration)) {
            return false;
        }
        WebsiteConfiguration other = (WebsiteConfiguration) obj;
        if (other.errorDocument() == null ^ this.errorDocument() == null) {
            return false;
        }
        if (other.errorDocument() != null && !other.errorDocument().equals(this.errorDocument())) {
            return false;
        }
        if (other.indexDocument() == null ^ this.indexDocument() == null) {
            return false;
        }
        if (other.indexDocument() != null && !other.indexDocument().equals(this.indexDocument())) {
            return false;
        }
        if (other.redirectAllRequestsTo() == null ^ this.redirectAllRequestsTo() == null) {
            return false;
        }
        if (other.redirectAllRequestsTo() != null && !other.redirectAllRequestsTo().equals(this.redirectAllRequestsTo())) {
            return false;
        }
        if (other.routingRules() == null ^ this.routingRules() == null) {
            return false;
        }
        if (other.routingRules() != null && !other.routingRules().equals(this.routingRules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (errorDocument() != null) {
            sb.append("ErrorDocument: ").append(errorDocument()).append(",");
        }
        if (indexDocument() != null) {
            sb.append("IndexDocument: ").append(indexDocument()).append(",");
        }
        if (redirectAllRequestsTo() != null) {
            sb.append("RedirectAllRequestsTo: ").append(redirectAllRequestsTo()).append(",");
        }
        if (routingRules() != null) {
            sb.append("RoutingRules: ").append(routingRules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, WebsiteConfiguration> {
        /**
         *
         * @param errorDocument
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDocument(ErrorDocument errorDocument);

        /**
         *
         * @param indexDocument
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexDocument(IndexDocument indexDocument);

        /**
         *
         * @param redirectAllRequestsTo
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo);

        /**
         *
         * @param routingRules
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRules(Collection<RoutingRule> routingRules);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRoutingRules(java.util.Collection)} or {@link #withRoutingRules(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param routingRules
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingRules(RoutingRule... routingRules);
    }

    private static final class BuilderImpl implements Builder {
        private ErrorDocument errorDocument;

        private IndexDocument indexDocument;

        private RedirectAllRequestsTo redirectAllRequestsTo;

        private List<RoutingRule> routingRules;

        private BuilderImpl() {
        }

        private BuilderImpl(WebsiteConfiguration model) {
            setErrorDocument(model.errorDocument);
            setIndexDocument(model.indexDocument);
            setRedirectAllRequestsTo(model.redirectAllRequestsTo);
            setRoutingRules(model.routingRules);
        }

        public final ErrorDocument getErrorDocument() {
            return errorDocument;
        }

        @Override
        public final Builder errorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        public final void setErrorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
        }

        public final IndexDocument getIndexDocument() {
            return indexDocument;
        }

        @Override
        public final Builder indexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
            return this;
        }

        public final void setIndexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
        }

        public final RedirectAllRequestsTo getRedirectAllRequestsTo() {
            return redirectAllRequestsTo;
        }

        @Override
        public final Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        public final void setRedirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
        }

        public final Collection<RoutingRule> getRoutingRules() {
            return routingRules;
        }

        @Override
        public final Builder routingRules(Collection<RoutingRule> routingRules) {
            this.routingRules = RoutingRulesCopier.copy(routingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(RoutingRule... routingRules) {
            if (this.routingRules == null) {
                this.routingRules = new ArrayList<>(routingRules.length);
            }
            for (RoutingRule e : routingRules) {
                this.routingRules.add(e);
            }
            return this;
        }

        public final void setRoutingRules(Collection<RoutingRule> routingRules) {
            this.routingRules = RoutingRulesCopier.copy(routingRules);
        }

        @SafeVarargs
        public final void setRoutingRules(RoutingRule... routingRules) {
            if (this.routingRules == null) {
                this.routingRules = new ArrayList<>(routingRules.length);
            }
            for (RoutingRule e : routingRules) {
                this.routingRules.add(e);
            }
        }

        @Override
        public WebsiteConfiguration build() {
            return new WebsiteConfiguration(this);
        }
    }
}
