/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UploadPartCopyRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UploadPartCopyRequest.Builder, UploadPartCopyRequest> {
    private final String bucket;

    private final String copySource;

    private final String copySourceIfMatch;

    private final Date copySourceIfModifiedSince;

    private final String copySourceIfNoneMatch;

    private final Date copySourceIfUnmodifiedSince;

    private final String copySourceRange;

    private final String key;

    private final Integer partNumber;

    private final String uploadId;

    private final String sseCustomerAlgorithm;

    private final String sseCustomerKey;

    private final String sseCustomerKeyMD5;

    private final String copySourceSSECustomerAlgorithm;

    private final String copySourceSSECustomerKey;

    private final String copySourceSSECustomerKeyMD5;

    private final String requestPayer;

    private UploadPartCopyRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.copySource = builder.copySource;
        this.copySourceIfMatch = builder.copySourceIfMatch;
        this.copySourceIfModifiedSince = builder.copySourceIfModifiedSince;
        this.copySourceIfNoneMatch = builder.copySourceIfNoneMatch;
        this.copySourceIfUnmodifiedSince = builder.copySourceIfUnmodifiedSince;
        this.copySourceRange = builder.copySourceRange;
        this.key = builder.key;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.copySourceSSECustomerAlgorithm = builder.copySourceSSECustomerAlgorithm;
        this.copySourceSSECustomerKey = builder.copySourceSSECustomerKey;
        this.copySourceSSECustomerKeyMD5 = builder.copySourceSSECustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
    }

    /**
     *
     * @return
     */
    public String bucket() {
        return bucket;
    }

    /**
     * The name of the source bucket and key name of the source object, separated by a slash (/). Must be URL-encoded.
     * 
     * @return The name of the source bucket and key name of the source object, separated by a slash (/). Must be
     *         URL-encoded.
     */
    public String copySource() {
        return copySource;
    }

    /**
     * Copies the object if its entity tag (ETag) matches the specified tag.
     * 
     * @return Copies the object if its entity tag (ETag) matches the specified tag.
     */
    public String copySourceIfMatch() {
        return copySourceIfMatch;
    }

    /**
     * Copies the object if it has been modified since the specified time.
     * 
     * @return Copies the object if it has been modified since the specified time.
     */
    public Date copySourceIfModifiedSince() {
        return copySourceIfModifiedSince;
    }

    /**
     * Copies the object if its entity tag (ETag) is different than the specified ETag.
     * 
     * @return Copies the object if its entity tag (ETag) is different than the specified ETag.
     */
    public String copySourceIfNoneMatch() {
        return copySourceIfNoneMatch;
    }

    /**
     * Copies the object if it hasn't been modified since the specified time.
     * 
     * @return Copies the object if it hasn't been modified since the specified time.
     */
    public Date copySourceIfUnmodifiedSince() {
        return copySourceIfUnmodifiedSince;
    }

    /**
     * The range of bytes to copy from the source object. The range value must use the form bytes=first-last, where the
     * first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates that you want to copy
     * the first ten bytes of the source. You can copy a range only if the source object is greater than 5 GB.
     * 
     * @return The range of bytes to copy from the source object. The range value must use the form bytes=first-last,
     *         where the first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates that
     *         you want to copy the first ten bytes of the source. You can copy a range only if the source object is
     *         greater than 5 GB.
     */
    public String copySourceRange() {
        return copySourceRange;
    }

    /**
     *
     * @return
     */
    public String key() {
        return key;
    }

    /**
     * Part number of part being copied. This is a positive integer between 1 and 10,000.
     * 
     * @return Part number of part being copied. This is a positive integer between 1 and 10,000.
     */
    public Integer partNumber() {
        return partNumber;
    }

    /**
     * Upload ID identifying the multipart upload whose part is being copied.
     * 
     * @return Upload ID identifying the multipart upload whose part is being copied.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     * 
     * @return Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     */
    public String sseCustomerAlgorithm() {
        return sseCustomerAlgorithm;
    }

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
     * store the object and then it is discarded; Amazon does not store the encryption key. The key must be appropriate
     * for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm header. This must
     * be the same encryption key specified in the initiate multipart upload request.
     * 
     * @return Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
     *         used to store the object and then it is discarded; Amazon does not store the encryption key. The key must
     *         be appropriate for use with the algorithm specified in the
     *         x-amz-server-side​-encryption​-customer-algorithm header. This must be the same encryption key specified
     *         in the initiate multipart upload request.
     */
    public String sseCustomerKey() {
        return sseCustomerKey;
    }

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a
     * message integrity check to ensure the encryption key was transmitted without error.
     * 
     * @return Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header
     *         for a message integrity check to ensure the encryption key was transmitted without error.
     */
    public String sseCustomerKeyMD5() {
        return sseCustomerKeyMD5;
    }

    /**
     * Specifies the algorithm to use when decrypting the source object (e.g., AES256).
     * 
     * @return Specifies the algorithm to use when decrypting the source object (e.g., AES256).
     */
    public String copySourceSSECustomerAlgorithm() {
        return copySourceSSECustomerAlgorithm;
    }

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption
     * key provided in this header must be one that was used when the source object was created.
     * 
     * @return Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The
     *         encryption key provided in this header must be one that was used when the source object was created.
     */
    public String copySourceSSECustomerKey() {
        return copySourceSSECustomerKey;
    }

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a
     * message integrity check to ensure the encryption key was transmitted without error.
     * 
     * @return Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header
     *         for a message integrity check to ensure the encryption key was transmitted without error.
     */
    public String copySourceSSECustomerKeyMD5() {
        return copySourceSSECustomerKeyMD5;
    }

    /**
     *
     * @return
     * @see RequestPayer
     */
    public String requestPayer() {
        return requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((copySource() == null) ? 0 : copySource().hashCode());
        hashCode = 31 * hashCode + ((copySourceIfMatch() == null) ? 0 : copySourceIfMatch().hashCode());
        hashCode = 31 * hashCode + ((copySourceIfModifiedSince() == null) ? 0 : copySourceIfModifiedSince().hashCode());
        hashCode = 31 * hashCode + ((copySourceIfNoneMatch() == null) ? 0 : copySourceIfNoneMatch().hashCode());
        hashCode = 31 * hashCode + ((copySourceIfUnmodifiedSince() == null) ? 0 : copySourceIfUnmodifiedSince().hashCode());
        hashCode = 31 * hashCode + ((copySourceRange() == null) ? 0 : copySourceRange().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((partNumber() == null) ? 0 : partNumber().hashCode());
        hashCode = 31 * hashCode + ((uploadId() == null) ? 0 : uploadId().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerAlgorithm() == null) ? 0 : sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKey() == null) ? 0 : sseCustomerKey().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKeyMD5() == null) ? 0 : sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((copySourceSSECustomerAlgorithm() == null) ? 0 : copySourceSSECustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((copySourceSSECustomerKey() == null) ? 0 : copySourceSSECustomerKey().hashCode());
        hashCode = 31 * hashCode + ((copySourceSSECustomerKeyMD5() == null) ? 0 : copySourceSSECustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((requestPayer() == null) ? 0 : requestPayer().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadPartCopyRequest)) {
            return false;
        }
        UploadPartCopyRequest other = (UploadPartCopyRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.copySource() == null ^ this.copySource() == null) {
            return false;
        }
        if (other.copySource() != null && !other.copySource().equals(this.copySource())) {
            return false;
        }
        if (other.copySourceIfMatch() == null ^ this.copySourceIfMatch() == null) {
            return false;
        }
        if (other.copySourceIfMatch() != null && !other.copySourceIfMatch().equals(this.copySourceIfMatch())) {
            return false;
        }
        if (other.copySourceIfModifiedSince() == null ^ this.copySourceIfModifiedSince() == null) {
            return false;
        }
        if (other.copySourceIfModifiedSince() != null
                && !other.copySourceIfModifiedSince().equals(this.copySourceIfModifiedSince())) {
            return false;
        }
        if (other.copySourceIfNoneMatch() == null ^ this.copySourceIfNoneMatch() == null) {
            return false;
        }
        if (other.copySourceIfNoneMatch() != null && !other.copySourceIfNoneMatch().equals(this.copySourceIfNoneMatch())) {
            return false;
        }
        if (other.copySourceIfUnmodifiedSince() == null ^ this.copySourceIfUnmodifiedSince() == null) {
            return false;
        }
        if (other.copySourceIfUnmodifiedSince() != null
                && !other.copySourceIfUnmodifiedSince().equals(this.copySourceIfUnmodifiedSince())) {
            return false;
        }
        if (other.copySourceRange() == null ^ this.copySourceRange() == null) {
            return false;
        }
        if (other.copySourceRange() != null && !other.copySourceRange().equals(this.copySourceRange())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.partNumber() == null ^ this.partNumber() == null) {
            return false;
        }
        if (other.partNumber() != null && !other.partNumber().equals(this.partNumber())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKey() == null ^ this.sseCustomerKey() == null) {
            return false;
        }
        if (other.sseCustomerKey() != null && !other.sseCustomerKey().equals(this.sseCustomerKey())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.copySourceSSECustomerAlgorithm() == null ^ this.copySourceSSECustomerAlgorithm() == null) {
            return false;
        }
        if (other.copySourceSSECustomerAlgorithm() != null
                && !other.copySourceSSECustomerAlgorithm().equals(this.copySourceSSECustomerAlgorithm())) {
            return false;
        }
        if (other.copySourceSSECustomerKey() == null ^ this.copySourceSSECustomerKey() == null) {
            return false;
        }
        if (other.copySourceSSECustomerKey() != null && !other.copySourceSSECustomerKey().equals(this.copySourceSSECustomerKey())) {
            return false;
        }
        if (other.copySourceSSECustomerKeyMD5() == null ^ this.copySourceSSECustomerKeyMD5() == null) {
            return false;
        }
        if (other.copySourceSSECustomerKeyMD5() != null
                && !other.copySourceSSECustomerKeyMD5().equals(this.copySourceSSECustomerKeyMD5())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        if (other.requestPayer() != null && !other.requestPayer().equals(this.requestPayer())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (copySource() != null) {
            sb.append("CopySource: ").append(copySource()).append(",");
        }
        if (copySourceIfMatch() != null) {
            sb.append("CopySourceIfMatch: ").append(copySourceIfMatch()).append(",");
        }
        if (copySourceIfModifiedSince() != null) {
            sb.append("CopySourceIfModifiedSince: ").append(copySourceIfModifiedSince()).append(",");
        }
        if (copySourceIfNoneMatch() != null) {
            sb.append("CopySourceIfNoneMatch: ").append(copySourceIfNoneMatch()).append(",");
        }
        if (copySourceIfUnmodifiedSince() != null) {
            sb.append("CopySourceIfUnmodifiedSince: ").append(copySourceIfUnmodifiedSince()).append(",");
        }
        if (copySourceRange() != null) {
            sb.append("CopySourceRange: ").append(copySourceRange()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (partNumber() != null) {
            sb.append("PartNumber: ").append(partNumber()).append(",");
        }
        if (uploadId() != null) {
            sb.append("UploadId: ").append(uploadId()).append(",");
        }
        if (sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(sseCustomerAlgorithm()).append(",");
        }
        if (sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(sseCustomerKey()).append(",");
        }
        if (sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(sseCustomerKeyMD5()).append(",");
        }
        if (copySourceSSECustomerAlgorithm() != null) {
            sb.append("CopySourceSSECustomerAlgorithm: ").append(copySourceSSECustomerAlgorithm()).append(",");
        }
        if (copySourceSSECustomerKey() != null) {
            sb.append("CopySourceSSECustomerKey: ").append(copySourceSSECustomerKey()).append(",");
        }
        if (copySourceSSECustomerKeyMD5() != null) {
            sb.append("CopySourceSSECustomerKeyMD5: ").append(copySourceSSECustomerKeyMD5()).append(",");
        }
        if (requestPayer() != null) {
            sb.append("RequestPayer: ").append(requestPayer()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UploadPartCopyRequest> {
        /**
         *
         * @param bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * The name of the source bucket and key name of the source object, separated by a slash (/). Must be
         * URL-encoded.
         * 
         * @param copySource
         *        The name of the source bucket and key name of the source object, separated by a slash (/). Must be
         *        URL-encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySource(String copySource);

        /**
         * Copies the object if its entity tag (ETag) matches the specified tag.
         * 
         * @param copySourceIfMatch
         *        Copies the object if its entity tag (ETag) matches the specified tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceIfMatch(String copySourceIfMatch);

        /**
         * Copies the object if it has been modified since the specified time.
         * 
         * @param copySourceIfModifiedSince
         *        Copies the object if it has been modified since the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceIfModifiedSince(Date copySourceIfModifiedSince);

        /**
         * Copies the object if its entity tag (ETag) is different than the specified ETag.
         * 
         * @param copySourceIfNoneMatch
         *        Copies the object if its entity tag (ETag) is different than the specified ETag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceIfNoneMatch(String copySourceIfNoneMatch);

        /**
         * Copies the object if it hasn't been modified since the specified time.
         * 
         * @param copySourceIfUnmodifiedSince
         *        Copies the object if it hasn't been modified since the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceIfUnmodifiedSince(Date copySourceIfUnmodifiedSince);

        /**
         * The range of bytes to copy from the source object. The range value must use the form bytes=first-last, where
         * the first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates that you want to
         * copy the first ten bytes of the source. You can copy a range only if the source object is greater than 5 GB.
         * 
         * @param copySourceRange
         *        The range of bytes to copy from the source object. The range value must use the form bytes=first-last,
         *        where the first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates
         *        that you want to copy the first ten bytes of the source. You can copy a range only if the source
         *        object is greater than 5 GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceRange(String copySourceRange);

        /**
         *
         * @param key
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Part number of part being copied. This is a positive integer between 1 and 10,000.
         * 
         * @param partNumber
         *        Part number of part being copied. This is a positive integer between 1 and 10,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumber(Integer partNumber);

        /**
         * Upload ID identifying the multipart upload whose part is being copied.
         * 
         * @param uploadId
         *        Upload ID identifying the multipart upload whose part is being copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * 
         * @param sseCustomerAlgorithm
         *        Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerAlgorithm(String sseCustomerAlgorithm);

        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
         * store the object and then it is discarded; Amazon does not store the encryption key. The key must be
         * appropriate for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
         * header. This must be the same encryption key specified in the initiate multipart upload request.
         * 
         * @param sseCustomerKey
         *        Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
         *        used to store the object and then it is discarded; Amazon does not store the encryption key. The key
         *        must be appropriate for use with the algorithm specified in the
         *        x-amz-server-side​-encryption​-customer-algorithm header. This must be the same encryption key
         *        specified in the initiate multipart upload request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKey(String sseCustomerKey);

        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for
         * a message integrity check to ensure the encryption key was transmitted without error.
         * 
         * @param sseCustomerKeyMD5
         *        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this
         *        header for a message integrity check to ensure the encryption key was transmitted without error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKeyMD5(String sseCustomerKeyMD5);

        /**
         * Specifies the algorithm to use when decrypting the source object (e.g., AES256).
         * 
         * @param copySourceSSECustomerAlgorithm
         *        Specifies the algorithm to use when decrypting the source object (e.g., AES256).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm);

        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The
         * encryption key provided in this header must be one that was used when the source object was created.
         * 
         * @param copySourceSSECustomerKey
         *        Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The
         *        encryption key provided in this header must be one that was used when the source object was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceSSECustomerKey(String copySourceSSECustomerKey);

        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for
         * a message integrity check to ensure the encryption key was transmitted without error.
         * 
         * @param copySourceSSECustomerKeyMD5
         *        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this
         *        header for a message integrity check to ensure the encryption key was transmitted without error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5);

        /**
         *
         * @param requestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         *
         * @param requestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String copySource;

        private String copySourceIfMatch;

        private Date copySourceIfModifiedSince;

        private String copySourceIfNoneMatch;

        private Date copySourceIfUnmodifiedSince;

        private String copySourceRange;

        private String key;

        private Integer partNumber;

        private String uploadId;

        private String sseCustomerAlgorithm;

        private String sseCustomerKey;

        private String sseCustomerKeyMD5;

        private String copySourceSSECustomerAlgorithm;

        private String copySourceSSECustomerKey;

        private String copySourceSSECustomerKeyMD5;

        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadPartCopyRequest model) {
            setBucket(model.bucket);
            setCopySource(model.copySource);
            setCopySourceIfMatch(model.copySourceIfMatch);
            setCopySourceIfModifiedSince(model.copySourceIfModifiedSince);
            setCopySourceIfNoneMatch(model.copySourceIfNoneMatch);
            setCopySourceIfUnmodifiedSince(model.copySourceIfUnmodifiedSince);
            setCopySourceRange(model.copySourceRange);
            setKey(model.key);
            setPartNumber(model.partNumber);
            setUploadId(model.uploadId);
            setSSECustomerAlgorithm(model.sseCustomerAlgorithm);
            setSSECustomerKey(model.sseCustomerKey);
            setSSECustomerKeyMD5(model.sseCustomerKeyMD5);
            setCopySourceSSECustomerAlgorithm(model.copySourceSSECustomerAlgorithm);
            setCopySourceSSECustomerKey(model.copySourceSSECustomerKey);
            setCopySourceSSECustomerKeyMD5(model.copySourceSSECustomerKeyMD5);
            setRequestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getCopySource() {
            return copySource;
        }

        @Override
        public final Builder copySource(String copySource) {
            this.copySource = copySource;
            return this;
        }

        public final void setCopySource(String copySource) {
            this.copySource = copySource;
        }

        public final String getCopySourceIfMatch() {
            return copySourceIfMatch;
        }

        @Override
        public final Builder copySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        public final void setCopySourceIfMatch(String copySourceIfMatch) {
            this.copySourceIfMatch = copySourceIfMatch;
        }

        public final Date getCopySourceIfModifiedSince() {
            return copySourceIfModifiedSince;
        }

        @Override
        public final Builder copySourceIfModifiedSince(Date copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = StandardMemberCopier.copy(copySourceIfModifiedSince);
            return this;
        }

        public final void setCopySourceIfModifiedSince(Date copySourceIfModifiedSince) {
            this.copySourceIfModifiedSince = StandardMemberCopier.copy(copySourceIfModifiedSince);
        }

        public final String getCopySourceIfNoneMatch() {
            return copySourceIfNoneMatch;
        }

        @Override
        public final Builder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        public final void setCopySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
        }

        public final Date getCopySourceIfUnmodifiedSince() {
            return copySourceIfUnmodifiedSince;
        }

        @Override
        public final Builder copySourceIfUnmodifiedSince(Date copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = StandardMemberCopier.copy(copySourceIfUnmodifiedSince);
            return this;
        }

        public final void setCopySourceIfUnmodifiedSince(Date copySourceIfUnmodifiedSince) {
            this.copySourceIfUnmodifiedSince = StandardMemberCopier.copy(copySourceIfUnmodifiedSince);
        }

        public final String getCopySourceRange() {
            return copySourceRange;
        }

        @Override
        public final Builder copySourceRange(String copySourceRange) {
            this.copySourceRange = copySourceRange;
            return this;
        }

        public final void setCopySourceRange(String copySourceRange) {
            this.copySourceRange = copySourceRange;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Integer getPartNumber() {
            return partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getSSECustomerAlgorithm() {
            return sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getCopySourceSSECustomerAlgorithm() {
            return copySourceSSECustomerAlgorithm;
        }

        @Override
        public final Builder copySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
            return this;
        }

        public final void setCopySourceSSECustomerAlgorithm(String copySourceSSECustomerAlgorithm) {
            this.copySourceSSECustomerAlgorithm = copySourceSSECustomerAlgorithm;
        }

        public final String getCopySourceSSECustomerKey() {
            return copySourceSSECustomerKey;
        }

        @Override
        public final Builder copySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
            return this;
        }

        public final void setCopySourceSSECustomerKey(String copySourceSSECustomerKey) {
            this.copySourceSSECustomerKey = copySourceSSECustomerKey;
        }

        public final String getCopySourceSSECustomerKeyMD5() {
            return copySourceSSECustomerKeyMD5;
        }

        @Override
        public final Builder copySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
            return this;
        }

        public final void setCopySourceSSECustomerKeyMD5(String copySourceSSECustomerKeyMD5) {
            this.copySourceSSECustomerKeyMD5 = copySourceSSECustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final void setRequestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
        }

        @Override
        public UploadPartCopyRequest build() {
            return new UploadPartCopyRequest(this);
        }
    }
}
