/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TopicConfigurationDeprecated implements
        ToCopyableBuilder<TopicConfigurationDeprecated.Builder, TopicConfigurationDeprecated> {
    private final String id;

    private final List<String> events;

    private final String event;

    private final String topic;

    private TopicConfigurationDeprecated(BuilderImpl builder) {
        this.id = builder.id;
        this.events = builder.events;
        this.event = builder.event;
        this.topic = builder.topic;
    }

    /**
     *
     * @return
     */
    public String id() {
        return id;
    }

    /**
     *
     * @return
     * @see Event
     */
    public List<String> events() {
        return events;
    }

    /**
     * Bucket event for which to send notifications.
     * 
     * @return Bucket event for which to send notifications.
     * @see Event
     */
    public String event() {
        return event;
    }

    /**
     * Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
     * 
     * @return Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
     */
    public String topic() {
        return topic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((event() == null) ? 0 : event().hashCode());
        hashCode = 31 * hashCode + ((topic() == null) ? 0 : topic().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicConfigurationDeprecated)) {
            return false;
        }
        TopicConfigurationDeprecated other = (TopicConfigurationDeprecated) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.event() == null ^ this.event() == null) {
            return false;
        }
        if (other.event() != null && !other.event().equals(this.event())) {
            return false;
        }
        if (other.topic() == null ^ this.topic() == null) {
            return false;
        }
        if (other.topic() != null && !other.topic().equals(this.topic())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (event() != null) {
            sb.append("Event: ").append(event()).append(",");
        }
        if (topic() != null) {
            sb.append("Topic: ").append(topic()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TopicConfigurationDeprecated> {
        /**
         *
         * @param id
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         *
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(Collection<String> events);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(String... events);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(Event... events);

        /**
         * Bucket event for which to send notifications.
         * 
         * @param event
         *        Bucket event for which to send notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(String event);

        /**
         * Bucket event for which to send notifications.
         * 
         * @param event
         *        Bucket event for which to send notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(Event event);

        /**
         * Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the bucket.
         * 
         * @param topic
         *        Amazon SNS topic to which Amazon S3 will publish a message to report the specified events for the
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private List<String> events;

        private String event;

        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicConfigurationDeprecated model) {
            setId(model.id);
            setEvents(model.events);
            setEvent(model.event);
            setTopic(model.topic);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Collection<String> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(String... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
        }

        @SafeVarargs
        public final void setEvents(Event... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final void setEvent(Event event) {
            this.event(event.toString());
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public TopicConfigurationDeprecated build() {
            return new TopicConfigurationDeprecated(this);
        }
    }
}
