/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPartsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListPartsResponse.Builder, ListPartsResponse> {
    private final Date abortDate;

    private final String abortRuleId;

    private final String bucket;

    private final String key;

    private final String uploadId;

    private final Integer partNumberMarker;

    private final Integer nextPartNumberMarker;

    private final Integer maxParts;

    private final Boolean isTruncated;

    private final List<Part> parts;

    private final Initiator initiator;

    private final Owner owner;

    private final String storageClass;

    private final String requestCharged;

    private ListPartsResponse(BuilderImpl builder) {
        this.abortDate = builder.abortDate;
        this.abortRuleId = builder.abortRuleId;
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.uploadId = builder.uploadId;
        this.partNumberMarker = builder.partNumberMarker;
        this.nextPartNumberMarker = builder.nextPartNumberMarker;
        this.maxParts = builder.maxParts;
        this.isTruncated = builder.isTruncated;
        this.parts = builder.parts;
        this.initiator = builder.initiator;
        this.owner = builder.owner;
        this.storageClass = builder.storageClass;
        this.requestCharged = builder.requestCharged;
    }

    /**
     * Date when multipart upload will become eligible for abort operation by lifecycle.
     * 
     * @return Date when multipart upload will become eligible for abort operation by lifecycle.
     */
    public Date abortDate() {
        return abortDate;
    }

    /**
     * Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
     * 
     * @return Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
     */
    public String abortRuleId() {
        return abortRuleId;
    }

    /**
     * Name of the bucket to which the multipart upload was initiated.
     * 
     * @return Name of the bucket to which the multipart upload was initiated.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Object key for which the multipart upload was initiated.
     * 
     * @return Object key for which the multipart upload was initiated.
     */
    public String key() {
        return key;
    }

    /**
     * Upload ID identifying the multipart upload whose parts are being listed.
     * 
     * @return Upload ID identifying the multipart upload whose parts are being listed.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     * Part number after which listing begins.
     * 
     * @return Part number after which listing begins.
     */
    public Integer partNumberMarker() {
        return partNumberMarker;
    }

    /**
     * When a list is truncated, this element specifies the last part in the list, as well as the value to use for the
     * part-number-marker request parameter in a subsequent request.
     * 
     * @return When a list is truncated, this element specifies the last part in the list, as well as the value to use
     *         for the part-number-marker request parameter in a subsequent request.
     */
    public Integer nextPartNumberMarker() {
        return nextPartNumberMarker;
    }

    /**
     * Maximum number of parts that were allowed in the response.
     * 
     * @return Maximum number of parts that were allowed in the response.
     */
    public Integer maxParts() {
        return maxParts;
    }

    /**
     * Indicates whether the returned list of parts is truncated.
     * 
     * @return Indicates whether the returned list of parts is truncated.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     *
     * @return
     */
    public List<Part> parts() {
        return parts;
    }

    /**
     * Identifies who initiated the multipart upload.
     * 
     * @return Identifies who initiated the multipart upload.
     */
    public Initiator initiator() {
        return initiator;
    }

    /**
     *
     * @return
     */
    public Owner owner() {
        return owner;
    }

    /**
     * The class of storage used to store the object.
     * 
     * @return The class of storage used to store the object.
     * @see StorageClass
     */
    public String storageClass() {
        return storageClass;
    }

    /**
     *
     * @return
     * @see RequestCharged
     */
    public String requestCharged() {
        return requestCharged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((abortDate() == null) ? 0 : abortDate().hashCode());
        hashCode = 31 * hashCode + ((abortRuleId() == null) ? 0 : abortRuleId().hashCode());
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((uploadId() == null) ? 0 : uploadId().hashCode());
        hashCode = 31 * hashCode + ((partNumberMarker() == null) ? 0 : partNumberMarker().hashCode());
        hashCode = 31 * hashCode + ((nextPartNumberMarker() == null) ? 0 : nextPartNumberMarker().hashCode());
        hashCode = 31 * hashCode + ((maxParts() == null) ? 0 : maxParts().hashCode());
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((parts() == null) ? 0 : parts().hashCode());
        hashCode = 31 * hashCode + ((initiator() == null) ? 0 : initiator().hashCode());
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        hashCode = 31 * hashCode + ((storageClass() == null) ? 0 : storageClass().hashCode());
        hashCode = 31 * hashCode + ((requestCharged() == null) ? 0 : requestCharged().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsResponse)) {
            return false;
        }
        ListPartsResponse other = (ListPartsResponse) obj;
        if (other.abortDate() == null ^ this.abortDate() == null) {
            return false;
        }
        if (other.abortDate() != null && !other.abortDate().equals(this.abortDate())) {
            return false;
        }
        if (other.abortRuleId() == null ^ this.abortRuleId() == null) {
            return false;
        }
        if (other.abortRuleId() != null && !other.abortRuleId().equals(this.abortRuleId())) {
            return false;
        }
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.partNumberMarker() == null ^ this.partNumberMarker() == null) {
            return false;
        }
        if (other.partNumberMarker() != null && !other.partNumberMarker().equals(this.partNumberMarker())) {
            return false;
        }
        if (other.nextPartNumberMarker() == null ^ this.nextPartNumberMarker() == null) {
            return false;
        }
        if (other.nextPartNumberMarker() != null && !other.nextPartNumberMarker().equals(this.nextPartNumberMarker())) {
            return false;
        }
        if (other.maxParts() == null ^ this.maxParts() == null) {
            return false;
        }
        if (other.maxParts() != null && !other.maxParts().equals(this.maxParts())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.parts() == null ^ this.parts() == null) {
            return false;
        }
        if (other.parts() != null && !other.parts().equals(this.parts())) {
            return false;
        }
        if (other.initiator() == null ^ this.initiator() == null) {
            return false;
        }
        if (other.initiator() != null && !other.initiator().equals(this.initiator())) {
            return false;
        }
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.storageClass() == null ^ this.storageClass() == null) {
            return false;
        }
        if (other.storageClass() != null && !other.storageClass().equals(this.storageClass())) {
            return false;
        }
        if (other.requestCharged() == null ^ this.requestCharged() == null) {
            return false;
        }
        if (other.requestCharged() != null && !other.requestCharged().equals(this.requestCharged())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (abortDate() != null) {
            sb.append("AbortDate: ").append(abortDate()).append(",");
        }
        if (abortRuleId() != null) {
            sb.append("AbortRuleId: ").append(abortRuleId()).append(",");
        }
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (uploadId() != null) {
            sb.append("UploadId: ").append(uploadId()).append(",");
        }
        if (partNumberMarker() != null) {
            sb.append("PartNumberMarker: ").append(partNumberMarker()).append(",");
        }
        if (nextPartNumberMarker() != null) {
            sb.append("NextPartNumberMarker: ").append(nextPartNumberMarker()).append(",");
        }
        if (maxParts() != null) {
            sb.append("MaxParts: ").append(maxParts()).append(",");
        }
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (parts() != null) {
            sb.append("Parts: ").append(parts()).append(",");
        }
        if (initiator() != null) {
            sb.append("Initiator: ").append(initiator()).append(",");
        }
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (storageClass() != null) {
            sb.append("StorageClass: ").append(storageClass()).append(",");
        }
        if (requestCharged() != null) {
            sb.append("RequestCharged: ").append(requestCharged()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListPartsResponse> {
        /**
         * Date when multipart upload will become eligible for abort operation by lifecycle.
         * 
         * @param abortDate
         *        Date when multipart upload will become eligible for abort operation by lifecycle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortDate(Date abortDate);

        /**
         * Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
         * 
         * @param abortRuleId
         *        Id of the lifecycle rule that makes a multipart upload eligible for abort operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortRuleId(String abortRuleId);

        /**
         * Name of the bucket to which the multipart upload was initiated.
         * 
         * @param bucket
         *        Name of the bucket to which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Object key for which the multipart upload was initiated.
         * 
         * @param key
         *        Object key for which the multipart upload was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Upload ID identifying the multipart upload whose parts are being listed.
         * 
         * @param uploadId
         *        Upload ID identifying the multipart upload whose parts are being listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * Part number after which listing begins.
         * 
         * @param partNumberMarker
         *        Part number after which listing begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumberMarker(Integer partNumberMarker);

        /**
         * When a list is truncated, this element specifies the last part in the list, as well as the value to use for
         * the part-number-marker request parameter in a subsequent request.
         * 
         * @param nextPartNumberMarker
         *        When a list is truncated, this element specifies the last part in the list, as well as the value to
         *        use for the part-number-marker request parameter in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPartNumberMarker(Integer nextPartNumberMarker);

        /**
         * Maximum number of parts that were allowed in the response.
         * 
         * @param maxParts
         *        Maximum number of parts that were allowed in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParts(Integer maxParts);

        /**
         * Indicates whether the returned list of parts is truncated.
         * 
         * @param isTruncated
         *        Indicates whether the returned list of parts is truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         *
         * @param parts
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Collection<Part> parts);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setParts(java.util.Collection)} or {@link #withParts(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param parts
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Part... parts);

        /**
         * Identifies who initiated the multipart upload.
         * 
         * @param initiator
         *        Identifies who initiated the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiator(Initiator initiator);

        /**
         *
         * @param owner
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * The class of storage used to store the object.
         * 
         * @param storageClass
         *        The class of storage used to store the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);

        /**
         *
         * @param requestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         *
         * @param requestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);
    }

    private static final class BuilderImpl implements Builder {
        private Date abortDate;

        private String abortRuleId;

        private String bucket;

        private String key;

        private String uploadId;

        private Integer partNumberMarker;

        private Integer nextPartNumberMarker;

        private Integer maxParts;

        private Boolean isTruncated;

        private List<Part> parts;

        private Initiator initiator;

        private Owner owner;

        private String storageClass;

        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsResponse model) {
            setAbortDate(model.abortDate);
            setAbortRuleId(model.abortRuleId);
            setBucket(model.bucket);
            setKey(model.key);
            setUploadId(model.uploadId);
            setPartNumberMarker(model.partNumberMarker);
            setNextPartNumberMarker(model.nextPartNumberMarker);
            setMaxParts(model.maxParts);
            setIsTruncated(model.isTruncated);
            setParts(model.parts);
            setInitiator(model.initiator);
            setOwner(model.owner);
            setStorageClass(model.storageClass);
            setRequestCharged(model.requestCharged);
        }

        public final Date getAbortDate() {
            return abortDate;
        }

        @Override
        public final Builder abortDate(Date abortDate) {
            this.abortDate = StandardMemberCopier.copy(abortDate);
            return this;
        }

        public final void setAbortDate(Date abortDate) {
            this.abortDate = StandardMemberCopier.copy(abortDate);
        }

        public final String getAbortRuleId() {
            return abortRuleId;
        }

        @Override
        public final Builder abortRuleId(String abortRuleId) {
            this.abortRuleId = abortRuleId;
            return this;
        }

        public final void setAbortRuleId(String abortRuleId) {
            this.abortRuleId = abortRuleId;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Integer getPartNumberMarker() {
            return partNumberMarker;
        }

        @Override
        public final Builder partNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public final void setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        public final Integer getNextPartNumberMarker() {
            return nextPartNumberMarker;
        }

        @Override
        public final Builder nextPartNumberMarker(Integer nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
            return this;
        }

        public final void setNextPartNumberMarker(Integer nextPartNumberMarker) {
            this.nextPartNumberMarker = nextPartNumberMarker;
        }

        public final Integer getMaxParts() {
            return maxParts;
        }

        @Override
        public final Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public final void setMaxParts(Integer maxParts) {
            this.maxParts = maxParts;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final Collection<Part> getParts() {
            return parts;
        }

        @Override
        public final Builder parts(Collection<Part> parts) {
            this.parts = PartsCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Part... parts) {
            if (this.parts == null) {
                this.parts = new ArrayList<>(parts.length);
            }
            for (Part e : parts) {
                this.parts.add(e);
            }
            return this;
        }

        public final void setParts(Collection<Part> parts) {
            this.parts = PartsCopier.copy(parts);
        }

        @SafeVarargs
        public final void setParts(Part... parts) {
            if (this.parts == null) {
                this.parts = new ArrayList<>(parts.length);
            }
            for (Part e : parts) {
                this.parts.add(e);
            }
        }

        public final Initiator getInitiator() {
            return initiator;
        }

        @Override
        public final Builder initiator(Initiator initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(Initiator initiator) {
            this.initiator = initiator;
        }

        public final Owner getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final void setStorageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final void setRequestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
        }

        @Override
        public ListPartsResponse build() {
            return new ListPartsResponse(this);
        }
    }
}
