/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPartsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ListPartsRequest.Builder, ListPartsRequest> {
    private final String bucket;

    private final String key;

    private final Integer maxParts;

    private final Integer partNumberMarker;

    private final String uploadId;

    private final String requestPayer;

    private ListPartsRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.maxParts = builder.maxParts;
        this.partNumberMarker = builder.partNumberMarker;
        this.uploadId = builder.uploadId;
        this.requestPayer = builder.requestPayer;
    }

    /**
     *
     * @return
     */
    public String bucket() {
        return bucket;
    }

    /**
     *
     * @return
     */
    public String key() {
        return key;
    }

    /**
     * Sets the maximum number of parts to return.
     * 
     * @return Sets the maximum number of parts to return.
     */
    public Integer maxParts() {
        return maxParts;
    }

    /**
     * Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.
     * 
     * @return Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.
     */
    public Integer partNumberMarker() {
        return partNumberMarker;
    }

    /**
     * Upload ID identifying the multipart upload whose parts are being listed.
     * 
     * @return Upload ID identifying the multipart upload whose parts are being listed.
     */
    public String uploadId() {
        return uploadId;
    }

    /**
     *
     * @return
     * @see RequestPayer
     */
    public String requestPayer() {
        return requestPayer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((maxParts() == null) ? 0 : maxParts().hashCode());
        hashCode = 31 * hashCode + ((partNumberMarker() == null) ? 0 : partNumberMarker().hashCode());
        hashCode = 31 * hashCode + ((uploadId() == null) ? 0 : uploadId().hashCode());
        hashCode = 31 * hashCode + ((requestPayer() == null) ? 0 : requestPayer().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartsRequest)) {
            return false;
        }
        ListPartsRequest other = (ListPartsRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.maxParts() == null ^ this.maxParts() == null) {
            return false;
        }
        if (other.maxParts() != null && !other.maxParts().equals(this.maxParts())) {
            return false;
        }
        if (other.partNumberMarker() == null ^ this.partNumberMarker() == null) {
            return false;
        }
        if (other.partNumberMarker() != null && !other.partNumberMarker().equals(this.partNumberMarker())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        if (other.requestPayer() != null && !other.requestPayer().equals(this.requestPayer())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (maxParts() != null) {
            sb.append("MaxParts: ").append(maxParts()).append(",");
        }
        if (partNumberMarker() != null) {
            sb.append("PartNumberMarker: ").append(partNumberMarker()).append(",");
        }
        if (uploadId() != null) {
            sb.append("UploadId: ").append(uploadId()).append(",");
        }
        if (requestPayer() != null) {
            sb.append("RequestPayer: ").append(requestPayer()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListPartsRequest> {
        /**
         *
         * @param bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         *
         * @param key
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Sets the maximum number of parts to return.
         * 
         * @param maxParts
         *        Sets the maximum number of parts to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxParts(Integer maxParts);

        /**
         * Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.
         * 
         * @param partNumberMarker
         *        Specifies the part after which listing should begin. Only parts with higher part numbers will be
         *        listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumberMarker(Integer partNumberMarker);

        /**
         * Upload ID identifying the multipart upload whose parts are being listed.
         * 
         * @param uploadId
         *        Upload ID identifying the multipart upload whose parts are being listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         *
         * @param requestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         *
         * @param requestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private Integer maxParts;

        private Integer partNumberMarker;

        private String uploadId;

        private String requestPayer;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartsRequest model) {
            setBucket(model.bucket);
            setKey(model.key);
            setMaxParts(model.maxParts);
            setPartNumberMarker(model.partNumberMarker);
            setUploadId(model.uploadId);
            setRequestPayer(model.requestPayer);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Integer getMaxParts() {
            return maxParts;
        }

        @Override
        public final Builder maxParts(Integer maxParts) {
            this.maxParts = maxParts;
            return this;
        }

        public final void setMaxParts(Integer maxParts) {
            this.maxParts = maxParts;
        }

        public final Integer getPartNumberMarker() {
            return partNumberMarker;
        }

        @Override
        public final Builder partNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
            return this;
        }

        public final void setPartNumberMarker(Integer partNumberMarker) {
            this.partNumberMarker = partNumberMarker;
        }

        public final String getUploadId() {
            return uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final void setRequestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
        }

        @Override
        public ListPartsRequest build() {
            return new ListPartsRequest(this);
        }
    }
}
