/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListObjectsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListObjectsResponse.Builder, ListObjectsResponse> {
    private final Boolean isTruncated;

    private final String marker;

    private final String nextMarker;

    private final List<S3Object> contents;

    private final String name;

    private final String prefix;

    private final String delimiter;

    private final Integer maxKeys;

    private final List<CommonPrefix> commonPrefixes;

    private final String encodingType;

    private ListObjectsResponse(BuilderImpl builder) {
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.nextMarker = builder.nextMarker;
        this.contents = builder.contents;
        this.name = builder.name;
        this.prefix = builder.prefix;
        this.delimiter = builder.delimiter;
        this.maxKeys = builder.maxKeys;
        this.commonPrefixes = builder.commonPrefixes;
        this.encodingType = builder.encodingType;
    }

    /**
     * A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search criteria.
     * 
     * @return A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
     *         criteria.
     */
    public Boolean isTruncated() {
        return isTruncated;
    }

    /**
     *
     * @return
     */
    public String marker() {
        return marker;
    }

    /**
     * When response is truncated (the IsTruncated element value in the response is true), you can use the key name in
     * this field as marker in the subsequent request to get next set of objects. Amazon S3 lists objects in
     * alphabetical order Note: This element is returned only if you have delimiter request parameter specified. If
     * response does not include the NextMaker and it is truncated, you can use the value of the last Key in the
     * response as the marker in the subsequent request to get the next set of object keys.
     * 
     * @return When response is truncated (the IsTruncated element value in the response is true), you can use the key
     *         name in this field as marker in the subsequent request to get next set of objects. Amazon S3 lists
     *         objects in alphabetical order Note: This element is returned only if you have delimiter request parameter
     *         specified. If response does not include the NextMaker and it is truncated, you can use the value of the
     *         last Key in the response as the marker in the subsequent request to get the next set of object keys.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     *
     * @return
     */
    public List<S3Object> contents() {
        return contents;
    }

    /**
     *
     * @return
     */
    public String name() {
        return name;
    }

    /**
     *
     * @return
     */
    public String prefix() {
        return prefix;
    }

    /**
     *
     * @return
     */
    public String delimiter() {
        return delimiter;
    }

    /**
     *
     * @return
     */
    public Integer maxKeys() {
        return maxKeys;
    }

    /**
     *
     * @return
     */
    public List<CommonPrefix> commonPrefixes() {
        return commonPrefixes;
    }

    /**
     * Encoding type used by Amazon S3 to encode object keys in the response.
     * 
     * @return Encoding type used by Amazon S3 to encode object keys in the response.
     * @see EncodingType
     */
    public String encodingType() {
        return encodingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((isTruncated() == null) ? 0 : isTruncated().hashCode());
        hashCode = 31 * hashCode + ((marker() == null) ? 0 : marker().hashCode());
        hashCode = 31 * hashCode + ((nextMarker() == null) ? 0 : nextMarker().hashCode());
        hashCode = 31 * hashCode + ((contents() == null) ? 0 : contents().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((prefix() == null) ? 0 : prefix().hashCode());
        hashCode = 31 * hashCode + ((delimiter() == null) ? 0 : delimiter().hashCode());
        hashCode = 31 * hashCode + ((maxKeys() == null) ? 0 : maxKeys().hashCode());
        hashCode = 31 * hashCode + ((commonPrefixes() == null) ? 0 : commonPrefixes().hashCode());
        hashCode = 31 * hashCode + ((encodingType() == null) ? 0 : encodingType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectsResponse)) {
            return false;
        }
        ListObjectsResponse other = (ListObjectsResponse) obj;
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.nextMarker() == null ^ this.nextMarker() == null) {
            return false;
        }
        if (other.nextMarker() != null && !other.nextMarker().equals(this.nextMarker())) {
            return false;
        }
        if (other.contents() == null ^ this.contents() == null) {
            return false;
        }
        if (other.contents() != null && !other.contents().equals(this.contents())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.prefix() == null ^ this.prefix() == null) {
            return false;
        }
        if (other.prefix() != null && !other.prefix().equals(this.prefix())) {
            return false;
        }
        if (other.delimiter() == null ^ this.delimiter() == null) {
            return false;
        }
        if (other.delimiter() != null && !other.delimiter().equals(this.delimiter())) {
            return false;
        }
        if (other.maxKeys() == null ^ this.maxKeys() == null) {
            return false;
        }
        if (other.maxKeys() != null && !other.maxKeys().equals(this.maxKeys())) {
            return false;
        }
        if (other.commonPrefixes() == null ^ this.commonPrefixes() == null) {
            return false;
        }
        if (other.commonPrefixes() != null && !other.commonPrefixes().equals(this.commonPrefixes())) {
            return false;
        }
        if (other.encodingType() == null ^ this.encodingType() == null) {
            return false;
        }
        if (other.encodingType() != null && !other.encodingType().equals(this.encodingType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (isTruncated() != null) {
            sb.append("IsTruncated: ").append(isTruncated()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (nextMarker() != null) {
            sb.append("NextMarker: ").append(nextMarker()).append(",");
        }
        if (contents() != null) {
            sb.append("Contents: ").append(contents()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (prefix() != null) {
            sb.append("Prefix: ").append(prefix()).append(",");
        }
        if (delimiter() != null) {
            sb.append("Delimiter: ").append(delimiter()).append(",");
        }
        if (maxKeys() != null) {
            sb.append("MaxKeys: ").append(maxKeys()).append(",");
        }
        if (commonPrefixes() != null) {
            sb.append("CommonPrefixes: ").append(commonPrefixes()).append(",");
        }
        if (encodingType() != null) {
            sb.append("EncodingType: ").append(encodingType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListObjectsResponse> {
        /**
         * A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
         * criteria.
         * 
         * @param isTruncated
         *        A flag that indicates whether or not Amazon S3 returned all of the results that satisfied the search
         *        criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         *
         * @param marker
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * When response is truncated (the IsTruncated element value in the response is true), you can use the key name
         * in this field as marker in the subsequent request to get next set of objects. Amazon S3 lists objects in
         * alphabetical order Note: This element is returned only if you have delimiter request parameter specified. If
         * response does not include the NextMaker and it is truncated, you can use the value of the last Key in the
         * response as the marker in the subsequent request to get the next set of object keys.
         * 
         * @param nextMarker
         *        When response is truncated (the IsTruncated element value in the response is true), you can use the
         *        key name in this field as marker in the subsequent request to get next set of objects. Amazon S3 lists
         *        objects in alphabetical order Note: This element is returned only if you have delimiter request
         *        parameter specified. If response does not include the NextMaker and it is truncated, you can use the
         *        value of the last Key in the response as the marker in the subsequent request to get the next set of
         *        object keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         *
         * @param contents
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contents(Collection<S3Object> contents);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setContents(java.util.Collection)} or {@link #withContents(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param contents
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contents(S3Object... contents);

        /**
         *
         * @param name
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         *
         * @param prefix
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         *
         * @param delimiter
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         *
         * @param maxKeys
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxKeys(Integer maxKeys);

        /**
         *
         * @param commonPrefixes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setCommonPrefixes(java.util.Collection)} or {@link #withCommonPrefixes(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param commonPrefixes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonPrefixes(CommonPrefix... commonPrefixes);

        /**
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(String encodingType);

        /**
         * Encoding type used by Amazon S3 to encode object keys in the response.
         * 
         * @param encodingType
         *        Encoding type used by Amazon S3 to encode object keys in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncodingType
         */
        Builder encodingType(EncodingType encodingType);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean isTruncated;

        private String marker;

        private String nextMarker;

        private List<S3Object> contents;

        private String name;

        private String prefix;

        private String delimiter;

        private Integer maxKeys;

        private List<CommonPrefix> commonPrefixes;

        private String encodingType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectsResponse model) {
            setIsTruncated(model.isTruncated);
            setMarker(model.marker);
            setNextMarker(model.nextMarker);
            setContents(model.contents);
            setName(model.name);
            setPrefix(model.prefix);
            setDelimiter(model.delimiter);
            setMaxKeys(model.maxKeys);
            setCommonPrefixes(model.commonPrefixes);
            setEncodingType(model.encodingType);
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<S3Object> getContents() {
            return contents;
        }

        @Override
        public final Builder contents(Collection<S3Object> contents) {
            this.contents = ObjectListCopier.copy(contents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contents(S3Object... contents) {
            if (this.contents == null) {
                this.contents = new ArrayList<>(contents.length);
            }
            for (S3Object e : contents) {
                this.contents.add(e);
            }
            return this;
        }

        public final void setContents(Collection<S3Object> contents) {
            this.contents = ObjectListCopier.copy(contents);
        }

        @SafeVarargs
        public final void setContents(S3Object... contents) {
            if (this.contents == null) {
                this.contents = new ArrayList<>(contents.length);
            }
            for (S3Object e : contents) {
                this.contents.add(e);
            }
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Integer getMaxKeys() {
            return maxKeys;
        }

        @Override
        public final Builder maxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
            return this;
        }

        public final void setMaxKeys(Integer maxKeys) {
            this.maxKeys = maxKeys;
        }

        public final Collection<CommonPrefix> getCommonPrefixes() {
            return commonPrefixes;
        }

        @Override
        public final Builder commonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commonPrefixes(CommonPrefix... commonPrefixes) {
            if (this.commonPrefixes == null) {
                this.commonPrefixes = new ArrayList<>(commonPrefixes.length);
            }
            for (CommonPrefix e : commonPrefixes) {
                this.commonPrefixes.add(e);
            }
            return this;
        }

        public final void setCommonPrefixes(Collection<CommonPrefix> commonPrefixes) {
            this.commonPrefixes = CommonPrefixListCopier.copy(commonPrefixes);
        }

        @SafeVarargs
        public final void setCommonPrefixes(CommonPrefix... commonPrefixes) {
            if (this.commonPrefixes == null) {
                this.commonPrefixes = new ArrayList<>(commonPrefixes.length);
            }
            for (CommonPrefix e : commonPrefixes) {
                this.commonPrefixes.add(e);
            }
        }

        public final String getEncodingType() {
            return encodingType;
        }

        @Override
        public final Builder encodingType(String encodingType) {
            this.encodingType = encodingType;
            return this;
        }

        @Override
        public final Builder encodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
            return this;
        }

        public final void setEncodingType(String encodingType) {
            this.encodingType = encodingType;
        }

        public final void setEncodingType(EncodingType encodingType) {
            this.encodingType(encodingType.toString());
        }

        @Override
        public ListObjectsResponse build() {
            return new ListObjectsResponse(this);
        }
    }
}
