/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class LifecycleConfiguration implements ToCopyableBuilder<LifecycleConfiguration.Builder, LifecycleConfiguration> {
    private final List<Rule> rules;

    private LifecycleConfiguration(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    /**
     *
     * @return
     */
    public List<Rule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((rules() == null) ? 0 : rules().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleConfiguration)) {
            return false;
        }
        LifecycleConfiguration other = (LifecycleConfiguration) obj;
        if (other.rules() == null ^ this.rules() == null) {
            return false;
        }
        if (other.rules() != null && !other.rules().equals(this.rules())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (rules() != null) {
            sb.append("Rules: ").append(rules()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, LifecycleConfiguration> {
        /**
         *
         * @param rules
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<Rule> rules);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRules(java.util.Collection)} or {@link #withRules(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param rules
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Rule... rules);
    }

    private static final class BuilderImpl implements Builder {
        private List<Rule> rules;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleConfiguration model) {
            setRules(model.rules);
        }

        public final Collection<Rule> getRules() {
            return rules;
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<>(rules.length);
            }
            for (Rule e : rules) {
                this.rules.add(e);
            }
            return this;
        }

        public final void setRules(Collection<Rule> rules) {
            this.rules = RulesCopier.copy(rules);
        }

        @SafeVarargs
        public final void setRules(Rule... rules) {
            if (this.rules == null) {
                this.rules = new ArrayList<>(rules.length);
            }
            for (Rule e : rules) {
                this.rules.add(e);
            }
        }

        @Override
        public LifecycleConfiguration build() {
            return new LifecycleConfiguration(this);
        }
    }
}
