/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Date;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetObjectRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetObjectRequest.Builder, GetObjectRequest> {
    private final String bucket;

    private final String ifMatch;

    private final Date ifModifiedSince;

    private final String ifNoneMatch;

    private final Date ifUnmodifiedSince;

    private final String key;

    private final String range;

    private final String responseCacheControl;

    private final String responseContentDisposition;

    private final String responseContentEncoding;

    private final String responseContentLanguage;

    private final String responseContentType;

    private final Date responseExpires;

    private final String versionId;

    private final String sseCustomerAlgorithm;

    private final String sseCustomerKey;

    private final String sseCustomerKeyMD5;

    private final String requestPayer;

    private final Integer partNumber;

    private GetObjectRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.ifMatch = builder.ifMatch;
        this.ifModifiedSince = builder.ifModifiedSince;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.ifUnmodifiedSince = builder.ifUnmodifiedSince;
        this.key = builder.key;
        this.range = builder.range;
        this.responseCacheControl = builder.responseCacheControl;
        this.responseContentDisposition = builder.responseContentDisposition;
        this.responseContentEncoding = builder.responseContentEncoding;
        this.responseContentLanguage = builder.responseContentLanguage;
        this.responseContentType = builder.responseContentType;
        this.responseExpires = builder.responseExpires;
        this.versionId = builder.versionId;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKey = builder.sseCustomerKey;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.requestPayer = builder.requestPayer;
        this.partNumber = builder.partNumber;
    }

    /**
     *
     * @return
     */
    public String bucket() {
        return bucket;
    }

    /**
     * Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412
     * (precondition failed).
     * 
     * @return Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412
     *         (precondition failed).
     */
    public String ifMatch() {
        return ifMatch;
    }

    /**
     * Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified).
     * 
     * @return Return the object only if it has been modified since the specified time, otherwise return a 304 (not
     *         modified).
     */
    public Date ifModifiedSince() {
        return ifModifiedSince;
    }

    /**
     * Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not
     * modified).
     * 
     * @return Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a
     *         304 (not modified).
     */
    public String ifNoneMatch() {
        return ifNoneMatch;
    }

    /**
     * Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition
     * failed).
     * 
     * @return Return the object only if it has not been modified since the specified time, otherwise return a 412
     *         (precondition failed).
     */
    public Date ifUnmodifiedSince() {
        return ifUnmodifiedSince;
    }

    /**
     *
     * @return
     */
    public String key() {
        return key;
    }

    /**
     * Downloads the specified range bytes of an object. For more information about the HTTP Range header, go to
     * http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
     * 
     * @return Downloads the specified range bytes of an object. For more information about the HTTP Range header, go to
     *         http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
     */
    public String range() {
        return range;
    }

    /**
     * Sets the Cache-Control header of the response.
     * 
     * @return Sets the Cache-Control header of the response.
     */
    public String responseCacheControl() {
        return responseCacheControl;
    }

    /**
     * Sets the Content-Disposition header of the response
     * 
     * @return Sets the Content-Disposition header of the response
     */
    public String responseContentDisposition() {
        return responseContentDisposition;
    }

    /**
     * Sets the Content-Encoding header of the response.
     * 
     * @return Sets the Content-Encoding header of the response.
     */
    public String responseContentEncoding() {
        return responseContentEncoding;
    }

    /**
     * Sets the Content-Language header of the response.
     * 
     * @return Sets the Content-Language header of the response.
     */
    public String responseContentLanguage() {
        return responseContentLanguage;
    }

    /**
     * Sets the Content-Type header of the response.
     * 
     * @return Sets the Content-Type header of the response.
     */
    public String responseContentType() {
        return responseContentType;
    }

    /**
     * Sets the Expires header of the response.
     * 
     * @return Sets the Expires header of the response.
     */
    public Date responseExpires() {
        return responseExpires;
    }

    /**
     * VersionId used to reference a specific version of the object.
     * 
     * @return VersionId used to reference a specific version of the object.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     * 
     * @return Specifies the algorithm to use to when encrypting the object (e.g., AES256).
     */
    public String sseCustomerAlgorithm() {
        return sseCustomerAlgorithm;
    }

    /**
     * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
     * store the object and then it is discarded; Amazon does not store the encryption key. The key must be appropriate
     * for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm header.
     * 
     * @return Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
     *         used to store the object and then it is discarded; Amazon does not store the encryption key. The key must
     *         be appropriate for use with the algorithm specified in the
     *         x-amz-server-side​-encryption​-customer-algorithm header.
     */
    public String sseCustomerKey() {
        return sseCustomerKey;
    }

    /**
     * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a
     * message integrity check to ensure the encryption key was transmitted without error.
     * 
     * @return Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header
     *         for a message integrity check to ensure the encryption key was transmitted without error.
     */
    public String sseCustomerKeyMD5() {
        return sseCustomerKeyMD5;
    }

    /**
     *
     * @return
     * @see RequestPayer
     */
    public String requestPayer() {
        return requestPayer;
    }

    /**
     * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a
     * 'ranged' GET request for the part specified. Useful for downloading just a part of an object.
     * 
     * @return Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively
     *         performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object.
     */
    public Integer partNumber() {
        return partNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bucket() == null) ? 0 : bucket().hashCode());
        hashCode = 31 * hashCode + ((ifMatch() == null) ? 0 : ifMatch().hashCode());
        hashCode = 31 * hashCode + ((ifModifiedSince() == null) ? 0 : ifModifiedSince().hashCode());
        hashCode = 31 * hashCode + ((ifNoneMatch() == null) ? 0 : ifNoneMatch().hashCode());
        hashCode = 31 * hashCode + ((ifUnmodifiedSince() == null) ? 0 : ifUnmodifiedSince().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((range() == null) ? 0 : range().hashCode());
        hashCode = 31 * hashCode + ((responseCacheControl() == null) ? 0 : responseCacheControl().hashCode());
        hashCode = 31 * hashCode + ((responseContentDisposition() == null) ? 0 : responseContentDisposition().hashCode());
        hashCode = 31 * hashCode + ((responseContentEncoding() == null) ? 0 : responseContentEncoding().hashCode());
        hashCode = 31 * hashCode + ((responseContentLanguage() == null) ? 0 : responseContentLanguage().hashCode());
        hashCode = 31 * hashCode + ((responseContentType() == null) ? 0 : responseContentType().hashCode());
        hashCode = 31 * hashCode + ((responseExpires() == null) ? 0 : responseExpires().hashCode());
        hashCode = 31 * hashCode + ((versionId() == null) ? 0 : versionId().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerAlgorithm() == null) ? 0 : sseCustomerAlgorithm().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKey() == null) ? 0 : sseCustomerKey().hashCode());
        hashCode = 31 * hashCode + ((sseCustomerKeyMD5() == null) ? 0 : sseCustomerKeyMD5().hashCode());
        hashCode = 31 * hashCode + ((requestPayer() == null) ? 0 : requestPayer().hashCode());
        hashCode = 31 * hashCode + ((partNumber() == null) ? 0 : partNumber().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectRequest)) {
            return false;
        }
        GetObjectRequest other = (GetObjectRequest) obj;
        if (other.bucket() == null ^ this.bucket() == null) {
            return false;
        }
        if (other.bucket() != null && !other.bucket().equals(this.bucket())) {
            return false;
        }
        if (other.ifMatch() == null ^ this.ifMatch() == null) {
            return false;
        }
        if (other.ifMatch() != null && !other.ifMatch().equals(this.ifMatch())) {
            return false;
        }
        if (other.ifModifiedSince() == null ^ this.ifModifiedSince() == null) {
            return false;
        }
        if (other.ifModifiedSince() != null && !other.ifModifiedSince().equals(this.ifModifiedSince())) {
            return false;
        }
        if (other.ifNoneMatch() == null ^ this.ifNoneMatch() == null) {
            return false;
        }
        if (other.ifNoneMatch() != null && !other.ifNoneMatch().equals(this.ifNoneMatch())) {
            return false;
        }
        if (other.ifUnmodifiedSince() == null ^ this.ifUnmodifiedSince() == null) {
            return false;
        }
        if (other.ifUnmodifiedSince() != null && !other.ifUnmodifiedSince().equals(this.ifUnmodifiedSince())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.range() == null ^ this.range() == null) {
            return false;
        }
        if (other.range() != null && !other.range().equals(this.range())) {
            return false;
        }
        if (other.responseCacheControl() == null ^ this.responseCacheControl() == null) {
            return false;
        }
        if (other.responseCacheControl() != null && !other.responseCacheControl().equals(this.responseCacheControl())) {
            return false;
        }
        if (other.responseContentDisposition() == null ^ this.responseContentDisposition() == null) {
            return false;
        }
        if (other.responseContentDisposition() != null
                && !other.responseContentDisposition().equals(this.responseContentDisposition())) {
            return false;
        }
        if (other.responseContentEncoding() == null ^ this.responseContentEncoding() == null) {
            return false;
        }
        if (other.responseContentEncoding() != null && !other.responseContentEncoding().equals(this.responseContentEncoding())) {
            return false;
        }
        if (other.responseContentLanguage() == null ^ this.responseContentLanguage() == null) {
            return false;
        }
        if (other.responseContentLanguage() != null && !other.responseContentLanguage().equals(this.responseContentLanguage())) {
            return false;
        }
        if (other.responseContentType() == null ^ this.responseContentType() == null) {
            return false;
        }
        if (other.responseContentType() != null && !other.responseContentType().equals(this.responseContentType())) {
            return false;
        }
        if (other.responseExpires() == null ^ this.responseExpires() == null) {
            return false;
        }
        if (other.responseExpires() != null && !other.responseExpires().equals(this.responseExpires())) {
            return false;
        }
        if (other.versionId() == null ^ this.versionId() == null) {
            return false;
        }
        if (other.versionId() != null && !other.versionId().equals(this.versionId())) {
            return false;
        }
        if (other.sseCustomerAlgorithm() == null ^ this.sseCustomerAlgorithm() == null) {
            return false;
        }
        if (other.sseCustomerAlgorithm() != null && !other.sseCustomerAlgorithm().equals(this.sseCustomerAlgorithm())) {
            return false;
        }
        if (other.sseCustomerKey() == null ^ this.sseCustomerKey() == null) {
            return false;
        }
        if (other.sseCustomerKey() != null && !other.sseCustomerKey().equals(this.sseCustomerKey())) {
            return false;
        }
        if (other.sseCustomerKeyMD5() == null ^ this.sseCustomerKeyMD5() == null) {
            return false;
        }
        if (other.sseCustomerKeyMD5() != null && !other.sseCustomerKeyMD5().equals(this.sseCustomerKeyMD5())) {
            return false;
        }
        if (other.requestPayer() == null ^ this.requestPayer() == null) {
            return false;
        }
        if (other.requestPayer() != null && !other.requestPayer().equals(this.requestPayer())) {
            return false;
        }
        if (other.partNumber() == null ^ this.partNumber() == null) {
            return false;
        }
        if (other.partNumber() != null && !other.partNumber().equals(this.partNumber())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bucket() != null) {
            sb.append("Bucket: ").append(bucket()).append(",");
        }
        if (ifMatch() != null) {
            sb.append("IfMatch: ").append(ifMatch()).append(",");
        }
        if (ifModifiedSince() != null) {
            sb.append("IfModifiedSince: ").append(ifModifiedSince()).append(",");
        }
        if (ifNoneMatch() != null) {
            sb.append("IfNoneMatch: ").append(ifNoneMatch()).append(",");
        }
        if (ifUnmodifiedSince() != null) {
            sb.append("IfUnmodifiedSince: ").append(ifUnmodifiedSince()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (range() != null) {
            sb.append("Range: ").append(range()).append(",");
        }
        if (responseCacheControl() != null) {
            sb.append("ResponseCacheControl: ").append(responseCacheControl()).append(",");
        }
        if (responseContentDisposition() != null) {
            sb.append("ResponseContentDisposition: ").append(responseContentDisposition()).append(",");
        }
        if (responseContentEncoding() != null) {
            sb.append("ResponseContentEncoding: ").append(responseContentEncoding()).append(",");
        }
        if (responseContentLanguage() != null) {
            sb.append("ResponseContentLanguage: ").append(responseContentLanguage()).append(",");
        }
        if (responseContentType() != null) {
            sb.append("ResponseContentType: ").append(responseContentType()).append(",");
        }
        if (responseExpires() != null) {
            sb.append("ResponseExpires: ").append(responseExpires()).append(",");
        }
        if (versionId() != null) {
            sb.append("VersionId: ").append(versionId()).append(",");
        }
        if (sseCustomerAlgorithm() != null) {
            sb.append("SSECustomerAlgorithm: ").append(sseCustomerAlgorithm()).append(",");
        }
        if (sseCustomerKey() != null) {
            sb.append("SSECustomerKey: ").append(sseCustomerKey()).append(",");
        }
        if (sseCustomerKeyMD5() != null) {
            sb.append("SSECustomerKeyMD5: ").append(sseCustomerKeyMD5()).append(",");
        }
        if (requestPayer() != null) {
            sb.append("RequestPayer: ").append(requestPayer()).append(",");
        }
        if (partNumber() != null) {
            sb.append("PartNumber: ").append(partNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetObjectRequest> {
        /**
         *
         * @param bucket
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412
         * (precondition failed).
         * 
         * @param ifMatch
         *        Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a
         *        412 (precondition failed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * Return the object only if it has been modified since the specified time, otherwise return a 304 (not
         * modified).
         * 
         * @param ifModifiedSince
         *        Return the object only if it has been modified since the specified time, otherwise return a 304 (not
         *        modified).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifModifiedSince(Date ifModifiedSince);

        /**
         * Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304
         * (not modified).
         * 
         * @param ifNoneMatch
         *        Return the object only if its entity tag (ETag) is different from the one specified, otherwise return
         *        a 304 (not modified).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifNoneMatch(String ifNoneMatch);

        /**
         * Return the object only if it has not been modified since the specified time, otherwise return a 412
         * (precondition failed).
         * 
         * @param ifUnmodifiedSince
         *        Return the object only if it has not been modified since the specified time, otherwise return a 412
         *        (precondition failed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifUnmodifiedSince(Date ifUnmodifiedSince);

        /**
         *
         * @param key
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * Downloads the specified range bytes of an object. For more information about the HTTP Range header, go to
         * http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
         * 
         * @param range
         *        Downloads the specified range bytes of an object. For more information about the HTTP Range header, go
         *        to http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(String range);

        /**
         * Sets the Cache-Control header of the response.
         * 
         * @param responseCacheControl
         *        Sets the Cache-Control header of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCacheControl(String responseCacheControl);

        /**
         * Sets the Content-Disposition header of the response
         * 
         * @param responseContentDisposition
         *        Sets the Content-Disposition header of the response
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseContentDisposition(String responseContentDisposition);

        /**
         * Sets the Content-Encoding header of the response.
         * 
         * @param responseContentEncoding
         *        Sets the Content-Encoding header of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseContentEncoding(String responseContentEncoding);

        /**
         * Sets the Content-Language header of the response.
         * 
         * @param responseContentLanguage
         *        Sets the Content-Language header of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseContentLanguage(String responseContentLanguage);

        /**
         * Sets the Content-Type header of the response.
         * 
         * @param responseContentType
         *        Sets the Content-Type header of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseContentType(String responseContentType);

        /**
         * Sets the Expires header of the response.
         * 
         * @param responseExpires
         *        Sets the Expires header of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseExpires(Date responseExpires);

        /**
         * VersionId used to reference a specific version of the object.
         * 
         * @param versionId
         *        VersionId used to reference a specific version of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * 
         * @param sseCustomerAlgorithm
         *        Specifies the algorithm to use to when encrypting the object (e.g., AES256).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerAlgorithm(String sseCustomerAlgorithm);

        /**
         * Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to
         * store the object and then it is discarded; Amazon does not store the encryption key. The key must be
         * appropriate for use with the algorithm specified in the x-amz-server-side​-encryption​-customer-algorithm
         * header.
         * 
         * @param sseCustomerKey
         *        Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is
         *        used to store the object and then it is discarded; Amazon does not store the encryption key. The key
         *        must be appropriate for use with the algorithm specified in the
         *        x-amz-server-side​-encryption​-customer-algorithm header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKey(String sseCustomerKey);

        /**
         * Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for
         * a message integrity check to ensure the encryption key was transmitted without error.
         * 
         * @param sseCustomerKeyMD5
         *        Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this
         *        header for a message integrity check to ensure the encryption key was transmitted without error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseCustomerKeyMD5(String sseCustomerKeyMD5);

        /**
         *
         * @param requestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         *
         * @param requestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);

        /**
         * Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a
         * 'ranged' GET request for the part specified. Useful for downloading just a part of an object.
         * 
         * @param partNumber
         *        Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively
         *        performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an
         *        object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumber(Integer partNumber);
    }

    private static final class BuilderImpl implements Builder {
        private String bucket;

        private String ifMatch;

        private Date ifModifiedSince;

        private String ifNoneMatch;

        private Date ifUnmodifiedSince;

        private String key;

        private String range;

        private String responseCacheControl;

        private String responseContentDisposition;

        private String responseContentEncoding;

        private String responseContentLanguage;

        private String responseContentType;

        private Date responseExpires;

        private String versionId;

        private String sseCustomerAlgorithm;

        private String sseCustomerKey;

        private String sseCustomerKeyMD5;

        private String requestPayer;

        private Integer partNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectRequest model) {
            setBucket(model.bucket);
            setIfMatch(model.ifMatch);
            setIfModifiedSince(model.ifModifiedSince);
            setIfNoneMatch(model.ifNoneMatch);
            setIfUnmodifiedSince(model.ifUnmodifiedSince);
            setKey(model.key);
            setRange(model.range);
            setResponseCacheControl(model.responseCacheControl);
            setResponseContentDisposition(model.responseContentDisposition);
            setResponseContentEncoding(model.responseContentEncoding);
            setResponseContentLanguage(model.responseContentLanguage);
            setResponseContentType(model.responseContentType);
            setResponseExpires(model.responseExpires);
            setVersionId(model.versionId);
            setSSECustomerAlgorithm(model.sseCustomerAlgorithm);
            setSSECustomerKey(model.sseCustomerKey);
            setSSECustomerKeyMD5(model.sseCustomerKeyMD5);
            setRequestPayer(model.requestPayer);
            setPartNumber(model.partNumber);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        public final Date getIfModifiedSince() {
            return ifModifiedSince;
        }

        @Override
        public final Builder ifModifiedSince(Date ifModifiedSince) {
            this.ifModifiedSince = StandardMemberCopier.copy(ifModifiedSince);
            return this;
        }

        public final void setIfModifiedSince(Date ifModifiedSince) {
            this.ifModifiedSince = StandardMemberCopier.copy(ifModifiedSince);
        }

        public final String getIfNoneMatch() {
            return ifNoneMatch;
        }

        @Override
        public final Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public final void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        public final Date getIfUnmodifiedSince() {
            return ifUnmodifiedSince;
        }

        @Override
        public final Builder ifUnmodifiedSince(Date ifUnmodifiedSince) {
            this.ifUnmodifiedSince = StandardMemberCopier.copy(ifUnmodifiedSince);
            return this;
        }

        public final void setIfUnmodifiedSince(Date ifUnmodifiedSince) {
            this.ifUnmodifiedSince = StandardMemberCopier.copy(ifUnmodifiedSince);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getRange() {
            return range;
        }

        @Override
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        public final String getResponseCacheControl() {
            return responseCacheControl;
        }

        @Override
        public final Builder responseCacheControl(String responseCacheControl) {
            this.responseCacheControl = responseCacheControl;
            return this;
        }

        public final void setResponseCacheControl(String responseCacheControl) {
            this.responseCacheControl = responseCacheControl;
        }

        public final String getResponseContentDisposition() {
            return responseContentDisposition;
        }

        @Override
        public final Builder responseContentDisposition(String responseContentDisposition) {
            this.responseContentDisposition = responseContentDisposition;
            return this;
        }

        public final void setResponseContentDisposition(String responseContentDisposition) {
            this.responseContentDisposition = responseContentDisposition;
        }

        public final String getResponseContentEncoding() {
            return responseContentEncoding;
        }

        @Override
        public final Builder responseContentEncoding(String responseContentEncoding) {
            this.responseContentEncoding = responseContentEncoding;
            return this;
        }

        public final void setResponseContentEncoding(String responseContentEncoding) {
            this.responseContentEncoding = responseContentEncoding;
        }

        public final String getResponseContentLanguage() {
            return responseContentLanguage;
        }

        @Override
        public final Builder responseContentLanguage(String responseContentLanguage) {
            this.responseContentLanguage = responseContentLanguage;
            return this;
        }

        public final void setResponseContentLanguage(String responseContentLanguage) {
            this.responseContentLanguage = responseContentLanguage;
        }

        public final String getResponseContentType() {
            return responseContentType;
        }

        @Override
        public final Builder responseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
            return this;
        }

        public final void setResponseContentType(String responseContentType) {
            this.responseContentType = responseContentType;
        }

        public final Date getResponseExpires() {
            return responseExpires;
        }

        @Override
        public final Builder responseExpires(Date responseExpires) {
            this.responseExpires = StandardMemberCopier.copy(responseExpires);
            return this;
        }

        public final void setResponseExpires(Date responseExpires) {
            this.responseExpires = StandardMemberCopier.copy(responseExpires);
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getSSECustomerAlgorithm() {
            return sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKey() {
            return sseCustomerKey;
        }

        @Override
        public final Builder sseCustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            return this;
        }

        public final void setSSECustomerKey(String sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
        }

        public final String getSSECustomerKeyMD5() {
            return sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getRequestPayer() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final void setRequestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
        }

        public final Integer getPartNumber() {
            return partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public GetObjectRequest build() {
            return new GetObjectRequest(this);
        }
    }
}
