/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetObjectAclResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetObjectAclResponse.Builder, GetObjectAclResponse> {
    private final Owner owner;

    private final List<Grant> grants;

    private final String requestCharged;

    private GetObjectAclResponse(BuilderImpl builder) {
        this.owner = builder.owner;
        this.grants = builder.grants;
        this.requestCharged = builder.requestCharged;
    }

    /**
     *
     * @return
     */
    public Owner owner() {
        return owner;
    }

    /**
     * A list of grants.
     * 
     * @return A list of grants.
     */
    public List<Grant> grants() {
        return grants;
    }

    /**
     *
     * @return
     * @see RequestCharged
     */
    public String requestCharged() {
        return requestCharged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((owner() == null) ? 0 : owner().hashCode());
        hashCode = 31 * hashCode + ((grants() == null) ? 0 : grants().hashCode());
        hashCode = 31 * hashCode + ((requestCharged() == null) ? 0 : requestCharged().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectAclResponse)) {
            return false;
        }
        GetObjectAclResponse other = (GetObjectAclResponse) obj;
        if (other.owner() == null ^ this.owner() == null) {
            return false;
        }
        if (other.owner() != null && !other.owner().equals(this.owner())) {
            return false;
        }
        if (other.grants() == null ^ this.grants() == null) {
            return false;
        }
        if (other.grants() != null && !other.grants().equals(this.grants())) {
            return false;
        }
        if (other.requestCharged() == null ^ this.requestCharged() == null) {
            return false;
        }
        if (other.requestCharged() != null && !other.requestCharged().equals(this.requestCharged())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (owner() != null) {
            sb.append("Owner: ").append(owner()).append(",");
        }
        if (grants() != null) {
            sb.append("Grants: ").append(grants()).append(",");
        }
        if (requestCharged() != null) {
            sb.append("RequestCharged: ").append(requestCharged()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetObjectAclResponse> {
        /**
         *
         * @param owner
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * A list of grants.
         * 
         * @param grants
         *        A list of grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Collection<Grant> grants);

        /**
         * A list of grants.
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setGrants(java.util.Collection)} or {@link #withGrants(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param grants
         *        A list of grants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grants(Grant... grants);

        /**
         *
         * @param requestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(String requestCharged);

        /**
         *
         * @param requestCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestCharged
         */
        Builder requestCharged(RequestCharged requestCharged);
    }

    private static final class BuilderImpl implements Builder {
        private Owner owner;

        private List<Grant> grants;

        private String requestCharged;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectAclResponse model) {
            setOwner(model.owner);
            setGrants(model.grants);
            setRequestCharged(model.requestCharged);
        }

        public final Owner getOwner() {
            return owner;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner owner) {
            this.owner = owner;
        }

        public final Collection<Grant> getGrants() {
            return grants;
        }

        @Override
        public final Builder grants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder grants(Grant... grants) {
            if (this.grants == null) {
                this.grants = new ArrayList<>(grants.length);
            }
            for (Grant e : grants) {
                this.grants.add(e);
            }
            return this;
        }

        public final void setGrants(Collection<Grant> grants) {
            this.grants = GrantsCopier.copy(grants);
        }

        @SafeVarargs
        public final void setGrants(Grant... grants) {
            if (this.grants == null) {
                this.grants = new ArrayList<>(grants.length);
            }
            for (Grant e : grants) {
                this.grants.add(e);
            }
        }

        public final String getRequestCharged() {
            return requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final void setRequestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
        }

        @Override
        public GetObjectAclResponse build() {
            return new GetObjectAclResponse(this);
        }
    }
}
