/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import static software.amazon.awssdk.util.StringUtils.isNullOrEmpty;

import java.util.stream.Stream;
import javax.annotation.Generated;

/**
 * Bucket event for which to send notifications.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Event {
    S3ReducedRedundancyLostObject("s3:ReducedRedundancyLostObject"),

    S3ObjectCreated("s3:ObjectCreated:*"),

    S3ObjectCreatedPut("s3:ObjectCreated:Put"),

    S3ObjectCreatedPost("s3:ObjectCreated:Post"),

    S3ObjectCreatedCopy("s3:ObjectCreated:Copy"),

    S3ObjectCreatedCompleteMultipartUpload("s3:ObjectCreated:CompleteMultipartUpload"),

    S3ObjectRemoved("s3:ObjectRemoved:*"),

    S3ObjectRemovedDelete("s3:ObjectRemoved:Delete"),

    S3ObjectRemovedDeleteMarkerCreated("s3:ObjectRemoved:DeleteMarkerCreated");

    private final String value;

    private Event(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return Event corresponding to the value
     */
    public static Event fromValue(String value) {
        if (isNullOrEmpty(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(Event.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}
