/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class Delete implements ToCopyableBuilder<Delete.Builder, Delete> {
    private final List<ObjectIdentifier> objects;

    private final Boolean quiet;

    private Delete(BuilderImpl builder) {
        this.objects = builder.objects;
        this.quiet = builder.quiet;
    }

    /**
     *
     * @return
     */
    public List<ObjectIdentifier> objects() {
        return objects;
    }

    /**
     * Element to enable quiet mode for the request. When you add this element, you must set its value to true.
     * 
     * @return Element to enable quiet mode for the request. When you add this element, you must set its value to true.
     */
    public Boolean quiet() {
        return quiet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((objects() == null) ? 0 : objects().hashCode());
        hashCode = 31 * hashCode + ((quiet() == null) ? 0 : quiet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delete)) {
            return false;
        }
        Delete other = (Delete) obj;
        if (other.objects() == null ^ this.objects() == null) {
            return false;
        }
        if (other.objects() != null && !other.objects().equals(this.objects())) {
            return false;
        }
        if (other.quiet() == null ^ this.quiet() == null) {
            return false;
        }
        if (other.quiet() != null && !other.quiet().equals(this.quiet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (objects() != null) {
            sb.append("Objects: ").append(objects()).append(",");
        }
        if (quiet() != null) {
            sb.append("Quiet: ").append(quiet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Delete> {
        /**
         *
         * @param objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(Collection<ObjectIdentifier> objects);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setObjects(java.util.Collection)} or {@link #withObjects(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param objects
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(ObjectIdentifier... objects);

        /**
         * Element to enable quiet mode for the request. When you add this element, you must set its value to true.
         * 
         * @param quiet
         *        Element to enable quiet mode for the request. When you add this element, you must set its value to
         *        true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quiet(Boolean quiet);
    }

    private static final class BuilderImpl implements Builder {
        private List<ObjectIdentifier> objects;

        private Boolean quiet;

        private BuilderImpl() {
        }

        private BuilderImpl(Delete model) {
            setObjects(model.objects);
            setQuiet(model.quiet);
        }

        public final Collection<ObjectIdentifier> getObjects() {
            return objects;
        }

        @Override
        public final Builder objects(Collection<ObjectIdentifier> objects) {
            this.objects = ObjectIdentifierListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(ObjectIdentifier... objects) {
            if (this.objects == null) {
                this.objects = new ArrayList<>(objects.length);
            }
            for (ObjectIdentifier e : objects) {
                this.objects.add(e);
            }
            return this;
        }

        public final void setObjects(Collection<ObjectIdentifier> objects) {
            this.objects = ObjectIdentifierListCopier.copy(objects);
        }

        @SafeVarargs
        public final void setObjects(ObjectIdentifier... objects) {
            if (this.objects == null) {
                this.objects = new ArrayList<>(objects.length);
            }
            for (ObjectIdentifier e : objects) {
                this.objects.add(e);
            }
        }

        public final Boolean getQuiet() {
            return quiet;
        }

        @Override
        public final Builder quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        public final void setQuiet(Boolean quiet) {
            this.quiet = quiet;
        }

        @Override
        public Delete build() {
            return new Delete(this);
        }
    }
}
