/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudFunctionConfiguration implements
        ToCopyableBuilder<CloudFunctionConfiguration.Builder, CloudFunctionConfiguration> {
    private final String id;

    private final String event;

    private final List<String> events;

    private final String cloudFunction;

    private final String invocationRole;

    private CloudFunctionConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.event = builder.event;
        this.events = builder.events;
        this.cloudFunction = builder.cloudFunction;
        this.invocationRole = builder.invocationRole;
    }

    /**
     *
     * @return
     */
    public String id() {
        return id;
    }

    /**
     *
     * @return
     * @see Event
     */
    public String event() {
        return event;
    }

    /**
     *
     * @return
     * @see Event
     */
    public List<String> events() {
        return events;
    }

    /**
     *
     * @return
     */
    public String cloudFunction() {
        return cloudFunction;
    }

    /**
     *
     * @return
     */
    public String invocationRole() {
        return invocationRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((id() == null) ? 0 : id().hashCode());
        hashCode = 31 * hashCode + ((event() == null) ? 0 : event().hashCode());
        hashCode = 31 * hashCode + ((events() == null) ? 0 : events().hashCode());
        hashCode = 31 * hashCode + ((cloudFunction() == null) ? 0 : cloudFunction().hashCode());
        hashCode = 31 * hashCode + ((invocationRole() == null) ? 0 : invocationRole().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFunctionConfiguration)) {
            return false;
        }
        CloudFunctionConfiguration other = (CloudFunctionConfiguration) obj;
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.event() == null ^ this.event() == null) {
            return false;
        }
        if (other.event() != null && !other.event().equals(this.event())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.cloudFunction() == null ^ this.cloudFunction() == null) {
            return false;
        }
        if (other.cloudFunction() != null && !other.cloudFunction().equals(this.cloudFunction())) {
            return false;
        }
        if (other.invocationRole() == null ^ this.invocationRole() == null) {
            return false;
        }
        if (other.invocationRole() != null && !other.invocationRole().equals(this.invocationRole())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (id() != null) {
            sb.append("Id: ").append(id()).append(",");
        }
        if (event() != null) {
            sb.append("Event: ").append(event()).append(",");
        }
        if (events() != null) {
            sb.append("Events: ").append(events()).append(",");
        }
        if (cloudFunction() != null) {
            sb.append("CloudFunction: ").append(cloudFunction()).append(",");
        }
        if (invocationRole() != null) {
            sb.append("InvocationRole: ").append(invocationRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CloudFunctionConfiguration> {
        /**
         *
         * @param id
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         *
         * @param event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(String event);

        /**
         *
         * @param event
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder event(Event event);

        /**
         *
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(Collection<String> events);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(String... events);

        /**
         *
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setEvents(java.util.Collection)} or {@link #withEvents(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param events
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Event
         */
        Builder events(Event... events);

        /**
         *
         * @param cloudFunction
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFunction(String cloudFunction);

        /**
         *
         * @param invocationRole
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationRole(String invocationRole);
    }

    private static final class BuilderImpl implements Builder {
        private String id;

        private String event;

        private List<String> events;

        private String cloudFunction;

        private String invocationRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFunctionConfiguration model) {
            setId(model.id);
            setEvent(model.event);
            setEvents(model.events);
            setCloudFunction(model.cloudFunction);
            setInvocationRole(model.invocationRole);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getEvent() {
            return event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(Event event) {
            this.event(event.toString());
            return this;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        public final void setEvent(Event event) {
            this.event(event.toString());
        }

        public final Collection<String> getEvents() {
            return events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(String... events) {
            if (this.events == null) {
                this.events = new ArrayList<>(events.length);
            }
            for (String e : events) {
                this.events.add(e);
            }
        }

        @SafeVarargs
        public final void setEvents(Event... events) {
            if (this.events == null) {
                this.events = new ArrayList<String>(events.length);
            }
            for (Event ele : events) {
                this.events.add(ele.toString());
            }
        }

        public final String getCloudFunction() {
            return cloudFunction;
        }

        @Override
        public final Builder cloudFunction(String cloudFunction) {
            this.cloudFunction = cloudFunction;
            return this;
        }

        public final void setCloudFunction(String cloudFunction) {
            this.cloudFunction = cloudFunction;
        }

        public final String getInvocationRole() {
            return invocationRole;
        }

        @Override
        public final Builder invocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
            return this;
        }

        public final void setInvocationRole(String invocationRole) {
            this.invocationRole = invocationRole;
        }

        @Override
        public CloudFunctionConfiguration build() {
            return new CloudFunctionConfiguration(this);
        }
    }
}
