/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * In the response to an <a href=
 * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_AssociateResolverQueryLogConfig.html"
 * >AssociateResolverQueryLogConfig</a>, <a href=
 * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_DisassociateResolverQueryLogConfig.html"
 * >DisassociateResolverQueryLogConfig</a>, <a href=
 * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverQueryLogConfigAssociation.html"
 * >GetResolverQueryLogConfigAssociation</a>, or <a href=
 * "https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverQueryLogConfigAssociations.html"
 * >ListResolverQueryLogConfigAssociations</a>, request, a complex type that contains settings for a specified
 * association between an Amazon VPC and a query logging configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResolverQueryLogConfigAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ResolverQueryLogConfigAssociation.Builder, ResolverQueryLogConfigAssociation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ResolverQueryLogConfigAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RESOLVER_QUERY_LOG_CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolverQueryLogConfigId").getter(getter(ResolverQueryLogConfigAssociation::resolverQueryLogConfigId))
            .setter(setter(Builder::resolverQueryLogConfigId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigId").build())
            .build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResolverQueryLogConfigAssociation::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ResolverQueryLogConfigAssociation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(ResolverQueryLogConfigAssociation::errorAsString)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(ResolverQueryLogConfigAssociation::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(ResolverQueryLogConfigAssociation::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            RESOLVER_QUERY_LOG_CONFIG_ID_FIELD, RESOURCE_ID_FIELD, STATUS_FIELD, ERROR_FIELD, ERROR_MESSAGE_FIELD,
            CREATION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String resolverQueryLogConfigId;

    private final String resourceId;

    private final String status;

    private final String error;

    private final String errorMessage;

    private final String creationTime;

    private ResolverQueryLogConfigAssociation(BuilderImpl builder) {
        this.id = builder.id;
        this.resolverQueryLogConfigId = builder.resolverQueryLogConfigId;
        this.resourceId = builder.resourceId;
        this.status = builder.status;
        this.error = builder.error;
        this.errorMessage = builder.errorMessage;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * The ID of the query logging association.
     * </p>
     * 
     * @return The ID of the query logging association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the query logging configuration that a VPC is associated with.
     * </p>
     * 
     * @return The ID of the query logging configuration that a VPC is associated with.
     */
    public final String resolverQueryLogConfigId() {
        return resolverQueryLogConfigId;
    }

    /**
     * <p>
     * The ID of the Amazon VPC that is associated with the query logging configuration.
     * </p>
     * 
     * @return The ID of the Amazon VPC that is associated with the query logging configuration.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The status of the specified query logging association. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The association between an Amazon VPC and a query logging configuration was successfully
     * created. Resolver is logging queries that originate in the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Resolver is deleting this query logging association.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverQueryLogConfigAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the specified query logging association. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The association between an Amazon VPC and a query logging configuration was
     *         successfully created. Resolver is logging queries that originate in the specified VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Resolver is deleting this query logging association.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
     *         </p>
     *         </li>
     * @see ResolverQueryLogConfigAssociationStatus
     */
    public final ResolverQueryLogConfigAssociationStatus status() {
        return ResolverQueryLogConfigAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the specified query logging association. Valid values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging
     * configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code>: The association between an Amazon VPC and a query logging configuration was successfully
     * created. Resolver is logging queries that originate in the specified VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>: Resolver is deleting this query logging association.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResolverQueryLogConfigAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the specified query logging association. Valid values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging
     *         configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>: The association between an Amazon VPC and a query logging configuration was
     *         successfully created. Resolver is logging queries that originate in the specified VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>: Resolver is deleting this query logging association.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
     *         </p>
     *         </li>
     * @see ResolverQueryLogConfigAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link ResolverQueryLogConfigAssociationError#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorAsString}.
     * </p>
     * 
     * @return If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the
     *         cause:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was
     *         deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is
     *         null.
     * @see ResolverQueryLogConfigAssociationError
     */
    public final ResolverQueryLogConfigAssociationError error() {
        return ResolverQueryLogConfigAssociationError.fromValue(error);
    }

    /**
     * <p>
     * If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the cause:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link ResolverQueryLogConfigAssociationError#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorAsString}.
     * </p>
     * 
     * @return If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the
     *         cause:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was
     *         deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is
     *         null.
     * @see ResolverQueryLogConfigAssociationError
     */
    public final String errorAsString() {
        return error;
    }

    /**
     * <p>
     * Contains additional information about the error. If the value or <code>Error</code> is null, the value of
     * <code>ErrorMessage</code> also is null.
     * </p>
     * 
     * @return Contains additional information about the error. If the value or <code>Error</code> is null, the value of
     *         <code>ErrorMessage</code> also is null.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The date and time that the VPC was associated with the query logging configuration, in Unix time format and
     * Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the VPC was associated with the query logging configuration, in Unix time format
     *         and Coordinated Universal Time (UTC).
     */
    public final String creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resolverQueryLogConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolverQueryLogConfigAssociation)) {
            return false;
        }
        ResolverQueryLogConfigAssociation other = (ResolverQueryLogConfigAssociation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resolverQueryLogConfigId(), other.resolverQueryLogConfigId())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorAsString(), other.errorAsString()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResolverQueryLogConfigAssociation").add("Id", id())
                .add("ResolverQueryLogConfigId", resolverQueryLogConfigId()).add("ResourceId", resourceId())
                .add("Status", statusAsString()).add("Error", errorAsString()).add("ErrorMessage", errorMessage())
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ResolverQueryLogConfigId":
            return Optional.ofNullable(clazz.cast(resolverQueryLogConfigId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Error":
            return Optional.ofNullable(clazz.cast(errorAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ResolverQueryLogConfigId", RESOLVER_QUERY_LOG_CONFIG_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolverQueryLogConfigAssociation, T> g) {
        return obj -> g.apply((ResolverQueryLogConfigAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResolverQueryLogConfigAssociation> {
        /**
         * <p>
         * The ID of the query logging association.
         * </p>
         * 
         * @param id
         *        The ID of the query logging association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the query logging configuration that a VPC is associated with.
         * </p>
         * 
         * @param resolverQueryLogConfigId
         *        The ID of the query logging configuration that a VPC is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfigId(String resolverQueryLogConfigId);

        /**
         * <p>
         * The ID of the Amazon VPC that is associated with the query logging configuration.
         * </p>
         * 
         * @param resourceId
         *        The ID of the Amazon VPC that is associated with the query logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The status of the specified query logging association. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The association between an Amazon VPC and a query logging configuration was successfully
         * created. Resolver is logging queries that originate in the specified VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Resolver is deleting this query logging association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the specified query logging association. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The association between an Amazon VPC and a query logging configuration was
         *        successfully created. Resolver is logging queries that originate in the specified VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Resolver is deleting this query logging association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
         *        </p>
         *        </li>
         * @see ResolverQueryLogConfigAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverQueryLogConfigAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the specified query logging association. Valid values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging
         * configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code>: The association between an Amazon VPC and a query logging configuration was successfully
         * created. Resolver is logging queries that originate in the specified VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>: Resolver is deleting this query logging association.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the specified query logging association. Valid values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code>: Resolver is creating an association between an Amazon VPC and a query logging
         *        configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>: The association between an Amazon VPC and a query logging configuration was
         *        successfully created. Resolver is logging queries that originate in the specified VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>: Resolver is deleting this query logging association.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: Resolver either couldn't create or couldn't delete the query logging association.
         *        </p>
         *        </li>
         * @see ResolverQueryLogConfigAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverQueryLogConfigAssociationStatus
         */
        Builder status(ResolverQueryLogConfigAssociationStatus status);

        /**
         * <p>
         * If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the
         * cause:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is null.
         * </p>
         * 
         * @param error
         *        If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates
         *        the cause:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was
         *        deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is
         *        null.
         * @see ResolverQueryLogConfigAssociationError
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverQueryLogConfigAssociationError
         */
        Builder error(String error);

        /**
         * <p>
         * If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates the
         * cause:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is null.
         * </p>
         * 
         * @param error
         *        If the value of <code>Status</code> is <code>FAILED</code>, the value of <code>Error</code> indicates
         *        the cause:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DESTINATION_NOT_FOUND</code>: The specified destination (for example, an Amazon S3 bucket) was
         *        deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCESS_DENIED</code>: Permissions don't allow sending logs to the destination.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the value of <code>Status</code> is a value other than <code>FAILED</code>, <code>Error</code> is
         *        null.
         * @see ResolverQueryLogConfigAssociationError
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverQueryLogConfigAssociationError
         */
        Builder error(ResolverQueryLogConfigAssociationError error);

        /**
         * <p>
         * Contains additional information about the error. If the value or <code>Error</code> is null, the value of
         * <code>ErrorMessage</code> also is null.
         * </p>
         * 
         * @param errorMessage
         *        Contains additional information about the error. If the value or <code>Error</code> is null, the value
         *        of <code>ErrorMessage</code> also is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The date and time that the VPC was associated with the query logging configuration, in Unix time format and
         * Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the VPC was associated with the query logging configuration, in Unix time
         *        format and Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String resolverQueryLogConfigId;

        private String resourceId;

        private String status;

        private String error;

        private String errorMessage;

        private String creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolverQueryLogConfigAssociation model) {
            id(model.id);
            resolverQueryLogConfigId(model.resolverQueryLogConfigId);
            resourceId(model.resourceId);
            status(model.status);
            error(model.error);
            errorMessage(model.errorMessage);
            creationTime(model.creationTime);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResolverQueryLogConfigId() {
            return resolverQueryLogConfigId;
        }

        public final void setResolverQueryLogConfigId(String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
        }

        @Override
        public final Builder resolverQueryLogConfigId(String resolverQueryLogConfigId) {
            this.resolverQueryLogConfigId = resolverQueryLogConfigId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResolverQueryLogConfigAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(ResolverQueryLogConfigAssociationError error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public ResolverQueryLogConfigAssociation build() {
            return new ResolverQueryLogConfigAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
