/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallRuleGroupAssociationsRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<ListFirewallRuleGroupAssociationsRequest.Builder, ListFirewallRuleGroupAssociationsRequest> {
    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallRuleGroupId").getter(getter(ListFirewallRuleGroupAssociationsRequest::firewallRuleGroupId))
            .setter(setter(Builder::firewallRuleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(ListFirewallRuleGroupAssociationsRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(ListFirewallRuleGroupAssociationsRequest::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListFirewallRuleGroupAssociationsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListFirewallRuleGroupAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFirewallRuleGroupAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULE_GROUP_ID_FIELD,
            VPC_ID_FIELD, PRIORITY_FIELD, STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String firewallRuleGroupId;

    private final String vpcId;

    private final Integer priority;

    private final String status;

    private final Integer maxResults;

    private final String nextToken;

    private ListFirewallRuleGroupAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.vpcId = builder.vpcId;
        this.priority = builder.priority;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this blank
     * to retrieve associations for any rule group.
     * </p>
     * 
     * @return The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave
     *         this blank to retrieve associations for any rule group.
     */
    public final String firewallRuleGroupId() {
        return firewallRuleGroupId;
    }

    /**
     * <p>
     * The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve
     * associations for any VPC.
     * </p>
     * 
     * @return The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to
     *         retrieve associations for any VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The setting that determines the processing order of the rule group among the rule groups that are associated with
     * a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority
     * setting.
     * </p>
     * 
     * @return The setting that determines the processing order of the rule group among the rule groups that are
     *         associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the
     *         lowest numeric priority setting.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't
     * specify this, then DNS Firewall returns all associations, regardless of status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallRuleGroupAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you
     *         don't specify this, then DNS Firewall returns all associations, regardless of status.
     * @see FirewallRuleGroupAssociationStatus
     */
    public final FirewallRuleGroupAssociationStatus status() {
        return FirewallRuleGroupAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you don't
     * specify this, then DNS Firewall returns all associations, regardless of status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallRuleGroupAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you
     *         don't specify this, then DNS Firewall returns all associations, regardless of status.
     * @see FirewallRuleGroupAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The maximum number of objects that you want Resolver to return for this request. If more objects are available,
     * in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent call to get
     * the next batch of objects.
     * </p>
     * <p>
     * If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects.
     * </p>
     * 
     * @return The maximum number of objects that you want Resolver to return for this request. If more objects are
     *         available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a
     *         subsequent call to get the next batch of objects.</p>
     *         <p>
     *         If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * For the first call to this list request, omit this value.
     * </p>
     * <p>
     * When you request a list of objects, Resolver returns at most the number of objects specified in
     * <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a <code>NextToken</code>
     * value in the response. To retrieve the next batch of objects, use the token that was returned for the prior
     * request in your next request.
     * </p>
     * 
     * @return For the first call to this list request, omit this value.</p>
     *         <p>
     *         When you request a list of objects, Resolver returns at most the number of objects specified in
     *         <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a
     *         <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that
     *         was returned for the prior request in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRuleGroupAssociationsRequest)) {
            return false;
        }
        ListFirewallRuleGroupAssociationsRequest other = (ListFirewallRuleGroupAssociationsRequest) obj;
        return Objects.equals(firewallRuleGroupId(), other.firewallRuleGroupId()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(priority(), other.priority()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallRuleGroupAssociationsRequest").add("FirewallRuleGroupId", firewallRuleGroupId())
                .add("VpcId", vpcId()).add("Priority", priority()).add("Status", statusAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallRuleGroupId":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FirewallRuleGroupId", FIREWALL_RULE_GROUP_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRuleGroupAssociationsRequest, T> g) {
        return obj -> g.apply((ListFirewallRuleGroupAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFirewallRuleGroupAssociationsRequest> {
        /**
         * <p>
         * The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this
         * blank to retrieve associations for any rule group.
         * </p>
         * 
         * @param firewallRuleGroupId
         *        The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave
         *        this blank to retrieve associations for any rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupId(String firewallRuleGroupId);

        /**
         * <p>
         * The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve
         * associations for any VPC.
         * </p>
         * 
         * @param vpcId
         *        The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to
         *        retrieve associations for any VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The setting that determines the processing order of the rule group among the rule groups that are associated
         * with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric
         * priority setting.
         * </p>
         * 
         * @param priority
         *        The setting that determines the processing order of the rule group among the rule groups that are
         *        associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the
         *        lowest numeric priority setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you
         * don't specify this, then DNS Firewall returns all associations, regardless of status.
         * </p>
         * 
         * @param status
         *        The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If
         *        you don't specify this, then DNS Firewall returns all associations, regardless of status.
         * @see FirewallRuleGroupAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleGroupAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If you
         * don't specify this, then DNS Firewall returns all associations, regardless of status.
         * </p>
         * 
         * @param status
         *        The association <code>Status</code> setting that you want DNS Firewall to filter on for the list. If
         *        you don't specify this, then DNS Firewall returns all associations, regardless of status.
         * @see FirewallRuleGroupAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleGroupAssociationStatus
         */
        Builder status(FirewallRuleGroupAssociationStatus status);

        /**
         * <p>
         * The maximum number of objects that you want Resolver to return for this request. If more objects are
         * available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a subsequent
         * call to get the next batch of objects.
         * </p>
         * <p>
         * If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects that you want Resolver to return for this request. If more objects are
         *        available, in the response, Resolver provides a <code>NextToken</code> value that you can use in a
         *        subsequent call to get the next batch of objects.</p>
         *        <p>
         *        If you don't specify a value for <code>MaxResults</code>, Resolver returns up to 100 objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * For the first call to this list request, omit this value.
         * </p>
         * <p>
         * When you request a list of objects, Resolver returns at most the number of objects specified in
         * <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a
         * <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token that was
         * returned for the prior request in your next request.
         * </p>
         * 
         * @param nextToken
         *        For the first call to this list request, omit this value.</p>
         *        <p>
         *        When you request a list of objects, Resolver returns at most the number of objects specified in
         *        <code>MaxResults</code>. If more objects are available for retrieval, Resolver returns a
         *        <code>NextToken</code> value in the response. To retrieve the next batch of objects, use the token
         *        that was returned for the prior request in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String firewallRuleGroupId;

        private String vpcId;

        private Integer priority;

        private String status;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRuleGroupAssociationsRequest model) {
            super(model);
            firewallRuleGroupId(model.firewallRuleGroupId);
            vpcId(model.vpcId);
            priority(model.priority);
            status(model.status);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getFirewallRuleGroupId() {
            return firewallRuleGroupId;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        @Override
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallRuleGroupAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFirewallRuleGroupAssociationsRequest build() {
            return new ListFirewallRuleGroupAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
