/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResolverQueryLogConfigPolicyResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetResolverQueryLogConfigPolicyResponse.Builder, GetResolverQueryLogConfigPolicyResponse> {
    private static final SdkField<String> RESOLVER_QUERY_LOG_CONFIG_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResolverQueryLogConfigPolicy")
            .getter(getter(GetResolverQueryLogConfigPolicyResponse::resolverQueryLogConfigPolicy))
            .setter(setter(Builder::resolverQueryLogConfigPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigPolicy")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOLVER_QUERY_LOG_CONFIG_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resolverQueryLogConfigPolicy;

    private GetResolverQueryLogConfigPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.resolverQueryLogConfigPolicy = builder.resolverQueryLogConfigPolicy;
    }

    /**
     * <p>
     * Information about the query logging policy for the query logging configuration that you specified in a
     * <code>GetResolverQueryLogConfigPolicy</code> request.
     * </p>
     * 
     * @return Information about the query logging policy for the query logging configuration that you specified in a
     *         <code>GetResolverQueryLogConfigPolicy</code> request.
     */
    public final String resolverQueryLogConfigPolicy() {
        return resolverQueryLogConfigPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverQueryLogConfigPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResolverQueryLogConfigPolicyResponse)) {
            return false;
        }
        GetResolverQueryLogConfigPolicyResponse other = (GetResolverQueryLogConfigPolicyResponse) obj;
        return Objects.equals(resolverQueryLogConfigPolicy(), other.resolverQueryLogConfigPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResolverQueryLogConfigPolicyResponse")
                .add("ResolverQueryLogConfigPolicy", resolverQueryLogConfigPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverQueryLogConfigPolicy":
            return Optional.ofNullable(clazz.cast(resolverQueryLogConfigPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResolverQueryLogConfigPolicy", RESOLVER_QUERY_LOG_CONFIG_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResolverQueryLogConfigPolicyResponse, T> g) {
        return obj -> g.apply((GetResolverQueryLogConfigPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResolverQueryLogConfigPolicyResponse> {
        /**
         * <p>
         * Information about the query logging policy for the query logging configuration that you specified in a
         * <code>GetResolverQueryLogConfigPolicy</code> request.
         * </p>
         * 
         * @param resolverQueryLogConfigPolicy
         *        Information about the query logging policy for the query logging configuration that you specified in a
         *        <code>GetResolverQueryLogConfigPolicy</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfigPolicy(String resolverQueryLogConfigPolicy);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String resolverQueryLogConfigPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResolverQueryLogConfigPolicyResponse model) {
            super(model);
            resolverQueryLogConfigPolicy(model.resolverQueryLogConfigPolicy);
        }

        public final String getResolverQueryLogConfigPolicy() {
            return resolverQueryLogConfigPolicy;
        }

        public final void setResolverQueryLogConfigPolicy(String resolverQueryLogConfigPolicy) {
            this.resolverQueryLogConfigPolicy = resolverQueryLogConfigPolicy;
        }

        @Override
        public final Builder resolverQueryLogConfigPolicy(String resolverQueryLogConfigPolicy) {
            this.resolverQueryLogConfigPolicy = resolverQueryLogConfigPolicy;
            return this;
        }

        @Override
        public GetResolverQueryLogConfigPolicyResponse build() {
            return new GetResolverQueryLogConfigPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
