/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53resolver.Route53ResolverClient;
import software.amazon.awssdk.services.route53resolver.model.FirewallRuleGroupAssociation;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsRequest;
import software.amazon.awssdk.services.route53resolver.model.ListFirewallRuleGroupAssociationsResponse;

public class ListFirewallRuleGroupAssociationsIterable
implements SdkIterable<ListFirewallRuleGroupAssociationsResponse> {
    private final Route53ResolverClient client;
    private final ListFirewallRuleGroupAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFirewallRuleGroupAssociationsIterable(Route53ResolverClient client, ListFirewallRuleGroupAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFirewallRuleGroupAssociationsResponseFetcher();
    }

    public Iterator<ListFirewallRuleGroupAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FirewallRuleGroupAssociation> firewallRuleGroupAssociations() {
        Function<ListFirewallRuleGroupAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallRuleGroupAssociations() != null) {
                return response.firewallRuleGroupAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFirewallRuleGroupAssociationsResponseFetcher
    implements SyncPageFetcher<ListFirewallRuleGroupAssociationsResponse> {
        private ListFirewallRuleGroupAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallRuleGroupAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFirewallRuleGroupAssociationsResponse nextPage(ListFirewallRuleGroupAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallRuleGroupAssociationsIterable.this.client.listFirewallRuleGroupAssociations(ListFirewallRuleGroupAssociationsIterable.this.firstRequest);
            }
            return ListFirewallRuleGroupAssociationsIterable.this.client.listFirewallRuleGroupAssociations((ListFirewallRuleGroupAssociationsRequest)((Object)ListFirewallRuleGroupAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

