/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53resolver.model.MutationProtectionStatus;
import software.amazon.awssdk.services.route53resolver.model.Route53ResolverRequest;
import software.amazon.awssdk.services.route53resolver.model.Tag;
import software.amazon.awssdk.services.route53resolver.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateFirewallRuleGroupRequest
extends Route53ResolverRequest
implements ToCopyableBuilder<Builder, AssociateFirewallRuleGroupRequest> {
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(AssociateFirewallRuleGroupRequest.getter(AssociateFirewallRuleGroupRequest::creatorRequestId)).setter(AssociateFirewallRuleGroupRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FIREWALL_RULE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirewallRuleGroupId").getter(AssociateFirewallRuleGroupRequest.getter(AssociateFirewallRuleGroupRequest::firewallRuleGroupId)).setter(AssociateFirewallRuleGroupRequest.setter(Builder::firewallRuleGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AssociateFirewallRuleGroupRequest.getter(AssociateFirewallRuleGroupRequest::vpcId)).setter(AssociateFirewallRuleGroupRequest.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Priority").getter(AssociateFirewallRuleGroupRequest.getter(AssociateFirewallRuleGroupRequest::priority)).setter(AssociateFirewallRuleGroupRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AssociateFirewallRuleGroupRequest.getter(AssociateFirewallRuleGroupRequest::name)).setter(AssociateFirewallRuleGroupRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> MUTATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MutationProtection").getter(AssociateFirewallRuleGroupRequest.getter(AssociateFirewallRuleGroupRequest::mutationProtectionAsString)).setter(AssociateFirewallRuleGroupRequest.setter(Builder::mutationProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutationProtection").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(AssociateFirewallRuleGroupRequest.getter(AssociateFirewallRuleGroupRequest::tags)).setter(AssociateFirewallRuleGroupRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATOR_REQUEST_ID_FIELD, FIREWALL_RULE_GROUP_ID_FIELD, VPC_ID_FIELD, PRIORITY_FIELD, NAME_FIELD, MUTATION_PROTECTION_FIELD, TAGS_FIELD));
    private final String creatorRequestId;
    private final String firewallRuleGroupId;
    private final String vpcId;
    private final Integer priority;
    private final String name;
    private final String mutationProtection;
    private final List<Tag> tags;

    private AssociateFirewallRuleGroupRequest(BuilderImpl builder) {
        super(builder);
        this.creatorRequestId = builder.creatorRequestId;
        this.firewallRuleGroupId = builder.firewallRuleGroupId;
        this.vpcId = builder.vpcId;
        this.priority = builder.priority;
        this.name = builder.name;
        this.mutationProtection = builder.mutationProtection;
        this.tags = builder.tags;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String firewallRuleGroupId() {
        return this.firewallRuleGroupId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final String name() {
        return this.name;
    }

    public final MutationProtectionStatus mutationProtection() {
        return MutationProtectionStatus.fromValue(this.mutationProtection);
    }

    public final String mutationProtectionAsString() {
        return this.mutationProtection;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallRuleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutationProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFirewallRuleGroupRequest)) {
            return false;
        }
        AssociateFirewallRuleGroupRequest other = (AssociateFirewallRuleGroupRequest)((Object)obj);
        return Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.firewallRuleGroupId(), other.firewallRuleGroupId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.mutationProtectionAsString(), other.mutationProtectionAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateFirewallRuleGroupRequest").add("CreatorRequestId", (Object)this.creatorRequestId()).add("FirewallRuleGroupId", (Object)this.firewallRuleGroupId()).add("VpcId", (Object)this.vpcId()).add("Priority", (Object)this.priority()).add("Name", (Object)this.name()).add("MutationProtection", (Object)this.mutationProtectionAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "FirewallRuleGroupId": {
                return Optional.ofNullable(clazz.cast(this.firewallRuleGroupId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "MutationProtection": {
                return Optional.ofNullable(clazz.cast(this.mutationProtectionAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateFirewallRuleGroupRequest, T> g) {
        return obj -> g.apply((AssociateFirewallRuleGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53ResolverRequest.BuilderImpl
    implements Builder {
        private String creatorRequestId;
        private String firewallRuleGroupId;
        private String vpcId;
        private Integer priority;
        private String name;
        private String mutationProtection;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFirewallRuleGroupRequest model) {
            super(model);
            this.creatorRequestId(model.creatorRequestId);
            this.firewallRuleGroupId(model.firewallRuleGroupId);
            this.vpcId(model.vpcId);
            this.priority(model.priority);
            this.name(model.name);
            this.mutationProtection(model.mutationProtection);
            this.tags(model.tags);
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getFirewallRuleGroupId() {
            return this.firewallRuleGroupId;
        }

        @Override
        public final Builder firewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        public final void setFirewallRuleGroupId(String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMutationProtection() {
            return this.mutationProtection;
        }

        @Override
        public final Builder mutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
            return this;
        }

        @Override
        public final Builder mutationProtection(MutationProtectionStatus mutationProtection) {
            this.mutationProtection(mutationProtection == null ? null : mutationProtection.toString());
            return this;
        }

        public final void setMutationProtection(String mutationProtection) {
            this.mutationProtection = mutationProtection;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateFirewallRuleGroupRequest build() {
            return new AssociateFirewallRuleGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53ResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateFirewallRuleGroupRequest> {
        public Builder creatorRequestId(String var1);

        public Builder firewallRuleGroupId(String var1);

        public Builder vpcId(String var1);

        public Builder priority(Integer var1);

        public Builder name(String var1);

        public Builder mutationProtection(String var1);

        public Builder mutationProtection(MutationProtectionStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

