/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResolverDnssecConfigRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<UpdateResolverDnssecConfigRequest.Builder, UpdateResolverDnssecConfigRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(UpdateResolverDnssecConfigRequest::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> VALIDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Validation").getter(getter(UpdateResolverDnssecConfigRequest::validationAsString))
            .setter(setter(Builder::validation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            VALIDATION_FIELD));

    private final String resourceId;

    private final String validation;

    private UpdateResolverDnssecConfigRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.validation = builder.validation;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code> or
     * <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validation} will
     * return {@link Validation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #validationAsString}.
     * </p>
     * 
     * @return The new value that you are specifying for DNSSEC validation for the VPC. The value can be
     *         <code>ENABLE</code> or <code>DISABLE</code>. Be aware that it can take time for a validation status
     *         change to be completed.
     * @see Validation
     */
    public final Validation validation() {
        return Validation.fromValue(validation);
    }

    /**
     * <p>
     * The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code> or
     * <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validation} will
     * return {@link Validation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #validationAsString}.
     * </p>
     * 
     * @return The new value that you are specifying for DNSSEC validation for the VPC. The value can be
     *         <code>ENABLE</code> or <code>DISABLE</code>. Be aware that it can take time for a validation status
     *         change to be completed.
     * @see Validation
     */
    public final String validationAsString() {
        return validation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(validationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverDnssecConfigRequest)) {
            return false;
        }
        UpdateResolverDnssecConfigRequest other = (UpdateResolverDnssecConfigRequest) obj;
        return Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(validationAsString(), other.validationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResolverDnssecConfigRequest").add("ResourceId", resourceId())
                .add("Validation", validationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Validation":
            return Optional.ofNullable(clazz.cast(validationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverDnssecConfigRequest, T> g) {
        return obj -> g.apply((UpdateResolverDnssecConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResolverDnssecConfigRequest> {
        /**
         * <p>
         * The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.
         * </p>
         * 
         * @param resourceId
         *        The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code>
         * or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.
         * </p>
         * 
         * @param validation
         *        The new value that you are specifying for DNSSEC validation for the VPC. The value can be
         *        <code>ENABLE</code> or <code>DISABLE</code>. Be aware that it can take time for a validation status
         *        change to be completed.
         * @see Validation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Validation
         */
        Builder validation(String validation);

        /**
         * <p>
         * The new value that you are specifying for DNSSEC validation for the VPC. The value can be <code>ENABLE</code>
         * or <code>DISABLE</code>. Be aware that it can take time for a validation status change to be completed.
         * </p>
         * 
         * @param validation
         *        The new value that you are specifying for DNSSEC validation for the VPC. The value can be
         *        <code>ENABLE</code> or <code>DISABLE</code>. Be aware that it can take time for a validation status
         *        change to be completed.
         * @see Validation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Validation
         */
        Builder validation(Validation validation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resourceId;

        private String validation;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverDnssecConfigRequest model) {
            super(model);
            resourceId(model.resourceId);
            validation(model.validation);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getValidation() {
            return validation;
        }

        @Override
        public final Builder validation(String validation) {
            this.validation = validation;
            return this;
        }

        @Override
        public final Builder validation(Validation validation) {
            this.validation(validation == null ? null : validation.toString());
            return this;
        }

        public final void setValidation(String validation) {
            this.validation = validation;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverDnssecConfigRequest build() {
            return new UpdateResolverDnssecConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
