/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResolverRuleAssociationsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListResolverRuleAssociationsResponse.Builder, ListResolverRuleAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResolverRuleAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResolverRuleAssociationsResponse::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<ResolverRuleAssociation>> RESOLVER_RULE_ASSOCIATIONS_FIELD = SdkField
            .<List<ResolverRuleAssociation>> builder(MarshallingType.LIST)
            .memberName("ResolverRuleAssociations")
            .getter(getter(ListResolverRuleAssociationsResponse::resolverRuleAssociations))
            .setter(setter(Builder::resolverRuleAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverRuleAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResolverRuleAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResolverRuleAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, RESOLVER_RULE_ASSOCIATIONS_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final List<ResolverRuleAssociation> resolverRuleAssociations;

    private ListResolverRuleAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.resolverRuleAssociations = builder.resolverRuleAssociations;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit another
     * <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next request, specify
     * the value of <code>NextToken</code> from the previous response.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit
     *         another <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next
     *         request, specify the value of <code>NextToken</code> from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The value that you specified for <code>MaxResults</code> in the request.
     * </p>
     * 
     * @return The value that you specified for <code>MaxResults</code> in the request.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns true if the ResolverRuleAssociations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResolverRuleAssociations() {
        return resolverRuleAssociations != null && !(resolverRuleAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associations that were created between Resolver rules and VPCs using the current AWS account, and that match
     * the specified filters, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResolverRuleAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The associations that were created between Resolver rules and VPCs using the current AWS account, and
     *         that match the specified filters, if any.
     */
    public final List<ResolverRuleAssociation> resolverRuleAssociations() {
        return resolverRuleAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasResolverRuleAssociations() ? resolverRuleAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverRuleAssociationsResponse)) {
            return false;
        }
        ListResolverRuleAssociationsResponse other = (ListResolverRuleAssociationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && hasResolverRuleAssociations() == other.hasResolverRuleAssociations()
                && Objects.equals(resolverRuleAssociations(), other.resolverRuleAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResolverRuleAssociationsResponse").add("NextToken", nextToken())
                .add("MaxResults", maxResults())
                .add("ResolverRuleAssociations", hasResolverRuleAssociations() ? resolverRuleAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ResolverRuleAssociations":
            return Optional.ofNullable(clazz.cast(resolverRuleAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverRuleAssociationsResponse, T> g) {
        return obj -> g.apply((ListResolverRuleAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResolverRuleAssociationsResponse> {
        /**
         * <p>
         * If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit another
         * <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next request,
         * specify the value of <code>NextToken</code> from the previous response.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> rule associations match the specified criteria, you can submit
         *        another <code>ListResolverRuleAssociation</code> request to get the next group of results. In the next
         *        request, specify the value of <code>NextToken</code> from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The value that you specified for <code>MaxResults</code> in the request.
         * </p>
         * 
         * @param maxResults
         *        The value that you specified for <code>MaxResults</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The associations that were created between Resolver rules and VPCs using the current AWS account, and that
         * match the specified filters, if any.
         * </p>
         * 
         * @param resolverRuleAssociations
         *        The associations that were created between Resolver rules and VPCs using the current AWS account, and
         *        that match the specified filters, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRuleAssociations(Collection<ResolverRuleAssociation> resolverRuleAssociations);

        /**
         * <p>
         * The associations that were created between Resolver rules and VPCs using the current AWS account, and that
         * match the specified filters, if any.
         * </p>
         * 
         * @param resolverRuleAssociations
         *        The associations that were created between Resolver rules and VPCs using the current AWS account, and
         *        that match the specified filters, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverRuleAssociations(ResolverRuleAssociation... resolverRuleAssociations);

        /**
         * <p>
         * The associations that were created between Resolver rules and VPCs using the current AWS account, and that
         * match the specified filters, if any.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResolverRuleAssociation>.Builder} avoiding
         * the need to create one manually via {@link List<ResolverRuleAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResolverRuleAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link #resolverRuleAssociations(List<ResolverRuleAssociation>)}.
         * 
         * @param resolverRuleAssociations
         *        a consumer that will call methods on {@link List<ResolverRuleAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverRuleAssociations(List<ResolverRuleAssociation>)
         */
        Builder resolverRuleAssociations(Consumer<ResolverRuleAssociation.Builder>... resolverRuleAssociations);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private List<ResolverRuleAssociation> resolverRuleAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverRuleAssociationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            resolverRuleAssociations(model.resolverRuleAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final List<ResolverRuleAssociation.Builder> getResolverRuleAssociations() {
            List<ResolverRuleAssociation.Builder> result = ResolverRuleAssociationsCopier
                    .copyToBuilder(this.resolverRuleAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resolverRuleAssociations(Collection<ResolverRuleAssociation> resolverRuleAssociations) {
            this.resolverRuleAssociations = ResolverRuleAssociationsCopier.copy(resolverRuleAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverRuleAssociations(ResolverRuleAssociation... resolverRuleAssociations) {
            resolverRuleAssociations(Arrays.asList(resolverRuleAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverRuleAssociations(Consumer<ResolverRuleAssociation.Builder>... resolverRuleAssociations) {
            resolverRuleAssociations(Stream.of(resolverRuleAssociations)
                    .map(c -> ResolverRuleAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolverRuleAssociations(Collection<ResolverRuleAssociation.BuilderImpl> resolverRuleAssociations) {
            this.resolverRuleAssociations = ResolverRuleAssociationsCopier.copyFromBuilder(resolverRuleAssociations);
        }

        @Override
        public ListResolverRuleAssociationsResponse build() {
            return new ListResolverRuleAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
