/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResolverQueryLogConfigAssociationsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListResolverQueryLogConfigAssociationsResponse.Builder, ListResolverQueryLogConfigAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResolverQueryLogConfigAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalCount").getter(getter(ListResolverQueryLogConfigAssociationsResponse::totalCount))
            .setter(setter(Builder::totalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()).build();

    private static final SdkField<Integer> TOTAL_FILTERED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalFilteredCount").getter(getter(ListResolverQueryLogConfigAssociationsResponse::totalFilteredCount))
            .setter(setter(Builder::totalFilteredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalFilteredCount").build())
            .build();

    private static final SdkField<List<ResolverQueryLogConfigAssociation>> RESOLVER_QUERY_LOG_CONFIG_ASSOCIATIONS_FIELD = SdkField
            .<List<ResolverQueryLogConfigAssociation>> builder(MarshallingType.LIST)
            .memberName("ResolverQueryLogConfigAssociations")
            .getter(getter(ListResolverQueryLogConfigAssociationsResponse::resolverQueryLogConfigAssociations))
            .setter(setter(Builder::resolverQueryLogConfigAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfigAssociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResolverQueryLogConfigAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResolverQueryLogConfigAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TOTAL_COUNT_FIELD, TOTAL_FILTERED_COUNT_FIELD, RESOLVER_QUERY_LOG_CONFIG_ASSOCIATIONS_FIELD));

    private final String nextToken;

    private final Integer totalCount;

    private final Integer totalFilteredCount;

    private final List<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations;

    private ListResolverQueryLogConfigAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
        this.totalFilteredCount = builder.totalFilteredCount;
        this.resolverQueryLogConfigAssociations = builder.resolverQueryLogConfigAssociations;
    }

    /**
     * <p>
     * If there are more than <code>MaxResults</code> query logging associations, you can submit another
     * <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the next
     * request, specify the value of <code>NextToken</code> from the previous response.
     * </p>
     * 
     * @return If there are more than <code>MaxResults</code> query logging associations, you can submit another
     *         <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the
     *         next request, specify the value of <code>NextToken</code> from the previous response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of query logging associations that were created by the current account in the specified Region.
     * This count can differ from the number of associations that are returned in a
     * <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify in the
     * request.
     * </p>
     * 
     * @return The total number of query logging associations that were created by the current account in the specified
     *         Region. This count can differ from the number of associations that are returned in a
     *         <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify in
     *         the request.
     */
    public final Integer totalCount() {
        return totalCount;
    }

    /**
     * <p>
     * The total number of query logging associations that were created by the current account in the specified Region
     * and that match the filters that were specified in the <code>ListResolverQueryLogConfigAssociations</code>
     * request. For the total number of associations that were created by the current account in the specified Region,
     * see <code>TotalCount</code>.
     * </p>
     * 
     * @return The total number of query logging associations that were created by the current account in the specified
     *         Region and that match the filters that were specified in the
     *         <code>ListResolverQueryLogConfigAssociations</code> request. For the total number of associations that
     *         were created by the current account in the specified Region, see <code>TotalCount</code>.
     */
    public final Integer totalFilteredCount() {
        return totalFilteredCount;
    }

    /**
     * Returns true if the ResolverQueryLogConfigAssociations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasResolverQueryLogConfigAssociations() {
        return resolverQueryLogConfigAssociations != null
                && !(resolverQueryLogConfigAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging
     * association that matches the values that you specified for <code>Filter</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResolverQueryLogConfigAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging
     *         association that matches the values that you specified for <code>Filter</code>.
     */
    public final List<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations() {
        return resolverQueryLogConfigAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(totalCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalFilteredCount());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasResolverQueryLogConfigAssociations() ? resolverQueryLogConfigAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResolverQueryLogConfigAssociationsResponse)) {
            return false;
        }
        ListResolverQueryLogConfigAssociationsResponse other = (ListResolverQueryLogConfigAssociationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(totalCount(), other.totalCount())
                && Objects.equals(totalFilteredCount(), other.totalFilteredCount())
                && hasResolverQueryLogConfigAssociations() == other.hasResolverQueryLogConfigAssociations()
                && Objects.equals(resolverQueryLogConfigAssociations(), other.resolverQueryLogConfigAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListResolverQueryLogConfigAssociationsResponse")
                .add("NextToken", nextToken())
                .add("TotalCount", totalCount())
                .add("TotalFilteredCount", totalFilteredCount())
                .add("ResolverQueryLogConfigAssociations",
                        hasResolverQueryLogConfigAssociations() ? resolverQueryLogConfigAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TotalCount":
            return Optional.ofNullable(clazz.cast(totalCount()));
        case "TotalFilteredCount":
            return Optional.ofNullable(clazz.cast(totalFilteredCount()));
        case "ResolverQueryLogConfigAssociations":
            return Optional.ofNullable(clazz.cast(resolverQueryLogConfigAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResolverQueryLogConfigAssociationsResponse, T> g) {
        return obj -> g.apply((ListResolverQueryLogConfigAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResolverQueryLogConfigAssociationsResponse> {
        /**
         * <p>
         * If there are more than <code>MaxResults</code> query logging associations, you can submit another
         * <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In the
         * next request, specify the value of <code>NextToken</code> from the previous response.
         * </p>
         * 
         * @param nextToken
         *        If there are more than <code>MaxResults</code> query logging associations, you can submit another
         *        <code>ListResolverQueryLogConfigAssociations</code> request to get the next group of associations. In
         *        the next request, specify the value of <code>NextToken</code> from the previous response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of query logging associations that were created by the current account in the specified
         * Region. This count can differ from the number of associations that are returned in a
         * <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify in the
         * request.
         * </p>
         * 
         * @param totalCount
         *        The total number of query logging associations that were created by the current account in the
         *        specified Region. This count can differ from the number of associations that are returned in a
         *        <code>ListResolverQueryLogConfigAssociations</code> response, depending on the values that you specify
         *        in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCount(Integer totalCount);

        /**
         * <p>
         * The total number of query logging associations that were created by the current account in the specified
         * Region and that match the filters that were specified in the
         * <code>ListResolverQueryLogConfigAssociations</code> request. For the total number of associations that were
         * created by the current account in the specified Region, see <code>TotalCount</code>.
         * </p>
         * 
         * @param totalFilteredCount
         *        The total number of query logging associations that were created by the current account in the
         *        specified Region and that match the filters that were specified in the
         *        <code>ListResolverQueryLogConfigAssociations</code> request. For the total number of associations that
         *        were created by the current account in the specified Region, see <code>TotalCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFilteredCount(Integer totalFilteredCount);

        /**
         * <p>
         * A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging
         * association that matches the values that you specified for <code>Filter</code>.
         * </p>
         * 
         * @param resolverQueryLogConfigAssociations
         *        A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query
         *        logging association that matches the values that you specified for <code>Filter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfigAssociations(
                Collection<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations);

        /**
         * <p>
         * A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging
         * association that matches the values that you specified for <code>Filter</code>.
         * </p>
         * 
         * @param resolverQueryLogConfigAssociations
         *        A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query
         *        logging association that matches the values that you specified for <code>Filter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfigAssociations(ResolverQueryLogConfigAssociation... resolverQueryLogConfigAssociations);

        /**
         * <p>
         * A list that contains one <code>ResolverQueryLogConfigAssociations</code> element for each query logging
         * association that matches the values that you specified for <code>Filter</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResolverQueryLogConfigAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<ResolverQueryLogConfigAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResolverQueryLogConfigAssociation>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #resolverQueryLogConfigAssociations(List<ResolverQueryLogConfigAssociation>)}.
         * 
         * @param resolverQueryLogConfigAssociations
         *        a consumer that will call methods on {@link List<ResolverQueryLogConfigAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverQueryLogConfigAssociations(List<ResolverQueryLogConfigAssociation>)
         */
        Builder resolverQueryLogConfigAssociations(
                Consumer<ResolverQueryLogConfigAssociation.Builder>... resolverQueryLogConfigAssociations);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Integer totalCount;

        private Integer totalFilteredCount;

        private List<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResolverQueryLogConfigAssociationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            totalCount(model.totalCount);
            totalFilteredCount(model.totalFilteredCount);
            resolverQueryLogConfigAssociations(model.resolverQueryLogConfigAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public final Integer getTotalFilteredCount() {
            return totalFilteredCount;
        }

        @Override
        public final Builder totalFilteredCount(Integer totalFilteredCount) {
            this.totalFilteredCount = totalFilteredCount;
            return this;
        }

        public final void setTotalFilteredCount(Integer totalFilteredCount) {
            this.totalFilteredCount = totalFilteredCount;
        }

        public final List<ResolverQueryLogConfigAssociation.Builder> getResolverQueryLogConfigAssociations() {
            List<ResolverQueryLogConfigAssociation.Builder> result = ResolverQueryLogConfigAssociationListCopier
                    .copyToBuilder(this.resolverQueryLogConfigAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resolverQueryLogConfigAssociations(
                Collection<ResolverQueryLogConfigAssociation> resolverQueryLogConfigAssociations) {
            this.resolverQueryLogConfigAssociations = ResolverQueryLogConfigAssociationListCopier
                    .copy(resolverQueryLogConfigAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverQueryLogConfigAssociations(
                ResolverQueryLogConfigAssociation... resolverQueryLogConfigAssociations) {
            resolverQueryLogConfigAssociations(Arrays.asList(resolverQueryLogConfigAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resolverQueryLogConfigAssociations(
                Consumer<ResolverQueryLogConfigAssociation.Builder>... resolverQueryLogConfigAssociations) {
            resolverQueryLogConfigAssociations(Stream.of(resolverQueryLogConfigAssociations)
                    .map(c -> ResolverQueryLogConfigAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResolverQueryLogConfigAssociations(
                Collection<ResolverQueryLogConfigAssociation.BuilderImpl> resolverQueryLogConfigAssociations) {
            this.resolverQueryLogConfigAssociations = ResolverQueryLogConfigAssociationListCopier
                    .copyFromBuilder(resolverQueryLogConfigAssociations);
        }

        @Override
        public ListResolverQueryLogConfigAssociationsResponse build() {
            return new ListResolverQueryLogConfigAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
