/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallRuleGroupsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListFirewallRuleGroupsResponse.Builder, ListFirewallRuleGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFirewallRuleGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<FirewallRuleGroupMetadata>> FIREWALL_RULE_GROUPS_FIELD = SdkField
            .<List<FirewallRuleGroupMetadata>> builder(MarshallingType.LIST)
            .memberName("FirewallRuleGroups")
            .getter(getter(ListFirewallRuleGroupsResponse::firewallRuleGroups))
            .setter(setter(Builder::firewallRuleGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallRuleGroupMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallRuleGroupMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            FIREWALL_RULE_GROUPS_FIELD));

    private final String nextToken;

    private final List<FirewallRuleGroupMetadata> firewallRuleGroups;

    private ListFirewallRuleGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallRuleGroups = builder.firewallRuleGroups;
    }

    /**
     * <p>
     * If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next
     * batch of objects, provide this token in your next request.
     * </p>
     * 
     * @return If objects are still available for retrieval, Resolver returns this token in the response. To retrieve
     *         the next batch of objects, provide this token in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the FirewallRuleGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFirewallRuleGroups() {
        return firewallRuleGroups != null && !(firewallRuleGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of your firewall rule groups.
     * </p>
     * <p>
     * This might be a partial list of the rule groups that you have defined. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFirewallRuleGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of your firewall rule groups.</p>
     *         <p>
     *         This might be a partial list of the rule groups that you have defined. For information, see
     *         <code>MaxResults</code>.
     */
    public final List<FirewallRuleGroupMetadata> firewallRuleGroups() {
        return firewallRuleGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFirewallRuleGroups() ? firewallRuleGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRuleGroupsResponse)) {
            return false;
        }
        ListFirewallRuleGroupsResponse other = (ListFirewallRuleGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasFirewallRuleGroups() == other.hasFirewallRuleGroups()
                && Objects.equals(firewallRuleGroups(), other.firewallRuleGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallRuleGroupsResponse").add("NextToken", nextToken())
                .add("FirewallRuleGroups", hasFirewallRuleGroups() ? firewallRuleGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FirewallRuleGroups":
            return Optional.ofNullable(clazz.cast(firewallRuleGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRuleGroupsResponse, T> g) {
        return obj -> g.apply((ListFirewallRuleGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFirewallRuleGroupsResponse> {
        /**
         * <p>
         * If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the
         * next batch of objects, provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If objects are still available for retrieval, Resolver returns this token in the response. To retrieve
         *        the next batch of objects, provide this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of your firewall rule groups.
         * </p>
         * <p>
         * This might be a partial list of the rule groups that you have defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * 
         * @param firewallRuleGroups
         *        A list of your firewall rule groups.</p>
         *        <p>
         *        This might be a partial list of the rule groups that you have defined. For information, see
         *        <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroups(Collection<FirewallRuleGroupMetadata> firewallRuleGroups);

        /**
         * <p>
         * A list of your firewall rule groups.
         * </p>
         * <p>
         * This might be a partial list of the rule groups that you have defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * 
         * @param firewallRuleGroups
         *        A list of your firewall rule groups.</p>
         *        <p>
         *        This might be a partial list of the rule groups that you have defined. For information, see
         *        <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroups(FirewallRuleGroupMetadata... firewallRuleGroups);

        /**
         * <p>
         * A list of your firewall rule groups.
         * </p>
         * <p>
         * This might be a partial list of the rule groups that you have defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FirewallRuleGroupMetadata>.Builder}
         * avoiding the need to create one manually via {@link List<FirewallRuleGroupMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FirewallRuleGroupMetadata>.Builder#build()} is called
         * immediately and its result is passed to {@link #firewallRuleGroups(List<FirewallRuleGroupMetadata>)}.
         * 
         * @param firewallRuleGroups
         *        a consumer that will call methods on {@link List<FirewallRuleGroupMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallRuleGroups(List<FirewallRuleGroupMetadata>)
         */
        Builder firewallRuleGroups(Consumer<FirewallRuleGroupMetadata.Builder>... firewallRuleGroups);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FirewallRuleGroupMetadata> firewallRuleGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRuleGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            firewallRuleGroups(model.firewallRuleGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<FirewallRuleGroupMetadata.Builder> getFirewallRuleGroups() {
            List<FirewallRuleGroupMetadata.Builder> result = FirewallRuleGroupMetadataListCopier
                    .copyToBuilder(this.firewallRuleGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder firewallRuleGroups(Collection<FirewallRuleGroupMetadata> firewallRuleGroups) {
            this.firewallRuleGroups = FirewallRuleGroupMetadataListCopier.copy(firewallRuleGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRuleGroups(FirewallRuleGroupMetadata... firewallRuleGroups) {
            firewallRuleGroups(Arrays.asList(firewallRuleGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRuleGroups(Consumer<FirewallRuleGroupMetadata.Builder>... firewallRuleGroups) {
            firewallRuleGroups(Stream.of(firewallRuleGroups)
                    .map(c -> FirewallRuleGroupMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFirewallRuleGroups(Collection<FirewallRuleGroupMetadata.BuilderImpl> firewallRuleGroups) {
            this.firewallRuleGroups = FirewallRuleGroupMetadataListCopier.copyFromBuilder(firewallRuleGroups);
        }

        @Override
        public ListFirewallRuleGroupsResponse build() {
            return new ListFirewallRuleGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
