/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallRuleGroupAssociationsResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<ListFirewallRuleGroupAssociationsResponse.Builder, ListFirewallRuleGroupAssociationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFirewallRuleGroupAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<FirewallRuleGroupAssociation>> FIREWALL_RULE_GROUP_ASSOCIATIONS_FIELD = SdkField
            .<List<FirewallRuleGroupAssociation>> builder(MarshallingType.LIST)
            .memberName("FirewallRuleGroupAssociations")
            .getter(getter(ListFirewallRuleGroupAssociationsResponse::firewallRuleGroupAssociations))
            .setter(setter(Builder::firewallRuleGroupAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallRuleGroupAssociations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallRuleGroupAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallRuleGroupAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            FIREWALL_RULE_GROUP_ASSOCIATIONS_FIELD));

    private final String nextToken;

    private final List<FirewallRuleGroupAssociation> firewallRuleGroupAssociations;

    private ListFirewallRuleGroupAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallRuleGroupAssociations = builder.firewallRuleGroupAssociations;
    }

    /**
     * <p>
     * If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the next
     * batch of objects, provide this token in your next request.
     * </p>
     * 
     * @return If objects are still available for retrieval, Resolver returns this token in the response. To retrieve
     *         the next batch of objects, provide this token in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the FirewallRuleGroupAssociations property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasFirewallRuleGroupAssociations() {
        return firewallRuleGroupAssociations != null && !(firewallRuleGroupAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of your firewall rule group associations.
     * </p>
     * <p>
     * This might be a partial list of the associations that you have defined. For information, see
     * <code>MaxResults</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFirewallRuleGroupAssociations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of your firewall rule group associations.</p>
     *         <p>
     *         This might be a partial list of the associations that you have defined. For information, see
     *         <code>MaxResults</code>.
     */
    public final List<FirewallRuleGroupAssociation> firewallRuleGroupAssociations() {
        return firewallRuleGroupAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFirewallRuleGroupAssociations() ? firewallRuleGroupAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRuleGroupAssociationsResponse)) {
            return false;
        }
        ListFirewallRuleGroupAssociationsResponse other = (ListFirewallRuleGroupAssociationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasFirewallRuleGroupAssociations() == other.hasFirewallRuleGroupAssociations()
                && Objects.equals(firewallRuleGroupAssociations(), other.firewallRuleGroupAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListFirewallRuleGroupAssociationsResponse")
                .add("NextToken", nextToken())
                .add("FirewallRuleGroupAssociations", hasFirewallRuleGroupAssociations() ? firewallRuleGroupAssociations() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FirewallRuleGroupAssociations":
            return Optional.ofNullable(clazz.cast(firewallRuleGroupAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRuleGroupAssociationsResponse, T> g) {
        return obj -> g.apply((ListFirewallRuleGroupAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFirewallRuleGroupAssociationsResponse> {
        /**
         * <p>
         * If objects are still available for retrieval, Resolver returns this token in the response. To retrieve the
         * next batch of objects, provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If objects are still available for retrieval, Resolver returns this token in the response. To retrieve
         *        the next batch of objects, provide this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of your firewall rule group associations.
         * </p>
         * <p>
         * This might be a partial list of the associations that you have defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * 
         * @param firewallRuleGroupAssociations
         *        A list of your firewall rule group associations.</p>
         *        <p>
         *        This might be a partial list of the associations that you have defined. For information, see
         *        <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupAssociations(Collection<FirewallRuleGroupAssociation> firewallRuleGroupAssociations);

        /**
         * <p>
         * A list of your firewall rule group associations.
         * </p>
         * <p>
         * This might be a partial list of the associations that you have defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * 
         * @param firewallRuleGroupAssociations
         *        A list of your firewall rule group associations.</p>
         *        <p>
         *        This might be a partial list of the associations that you have defined. For information, see
         *        <code>MaxResults</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRuleGroupAssociations(FirewallRuleGroupAssociation... firewallRuleGroupAssociations);

        /**
         * <p>
         * A list of your firewall rule group associations.
         * </p>
         * <p>
         * This might be a partial list of the associations that you have defined. For information, see
         * <code>MaxResults</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FirewallRuleGroupAssociation>.Builder}
         * avoiding the need to create one manually via {@link List<FirewallRuleGroupAssociation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FirewallRuleGroupAssociation>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #firewallRuleGroupAssociations(List<FirewallRuleGroupAssociation>)}.
         * 
         * @param firewallRuleGroupAssociations
         *        a consumer that will call methods on {@link List<FirewallRuleGroupAssociation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallRuleGroupAssociations(List<FirewallRuleGroupAssociation>)
         */
        Builder firewallRuleGroupAssociations(Consumer<FirewallRuleGroupAssociation.Builder>... firewallRuleGroupAssociations);
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FirewallRuleGroupAssociation> firewallRuleGroupAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRuleGroupAssociationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            firewallRuleGroupAssociations(model.firewallRuleGroupAssociations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final List<FirewallRuleGroupAssociation.Builder> getFirewallRuleGroupAssociations() {
            List<FirewallRuleGroupAssociation.Builder> result = FirewallRuleGroupAssociationsCopier
                    .copyToBuilder(this.firewallRuleGroupAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder firewallRuleGroupAssociations(Collection<FirewallRuleGroupAssociation> firewallRuleGroupAssociations) {
            this.firewallRuleGroupAssociations = FirewallRuleGroupAssociationsCopier.copy(firewallRuleGroupAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRuleGroupAssociations(FirewallRuleGroupAssociation... firewallRuleGroupAssociations) {
            firewallRuleGroupAssociations(Arrays.asList(firewallRuleGroupAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRuleGroupAssociations(
                Consumer<FirewallRuleGroupAssociation.Builder>... firewallRuleGroupAssociations) {
            firewallRuleGroupAssociations(Stream.of(firewallRuleGroupAssociations)
                    .map(c -> FirewallRuleGroupAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFirewallRuleGroupAssociations(
                Collection<FirewallRuleGroupAssociation.BuilderImpl> firewallRuleGroupAssociations) {
            this.firewallRuleGroupAssociations = FirewallRuleGroupAssociationsCopier
                    .copyFromBuilder(firewallRuleGroupAssociations);
        }

        @Override
        public ListFirewallRuleGroupAssociationsResponse build() {
            return new ListFirewallRuleGroupAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
