/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResolverQueryLogConfigResponse extends Route53ResolverResponse implements
        ToCopyableBuilder<GetResolverQueryLogConfigResponse.Builder, GetResolverQueryLogConfigResponse> {
    private static final SdkField<ResolverQueryLogConfig> RESOLVER_QUERY_LOG_CONFIG_FIELD = SdkField
            .<ResolverQueryLogConfig> builder(MarshallingType.SDK_POJO).memberName("ResolverQueryLogConfig")
            .getter(getter(GetResolverQueryLogConfigResponse::resolverQueryLogConfig))
            .setter(setter(Builder::resolverQueryLogConfig)).constructor(ResolverQueryLogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverQueryLogConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOLVER_QUERY_LOG_CONFIG_FIELD));

    private final ResolverQueryLogConfig resolverQueryLogConfig;

    private GetResolverQueryLogConfigResponse(BuilderImpl builder) {
        super(builder);
        this.resolverQueryLogConfig = builder.resolverQueryLogConfig;
    }

    /**
     * <p>
     * Information about the Resolver query logging configuration that you specified in a <code>GetQueryLogConfig</code>
     * request.
     * </p>
     * 
     * @return Information about the Resolver query logging configuration that you specified in a
     *         <code>GetQueryLogConfig</code> request.
     */
    public final ResolverQueryLogConfig resolverQueryLogConfig() {
        return resolverQueryLogConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverQueryLogConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResolverQueryLogConfigResponse)) {
            return false;
        }
        GetResolverQueryLogConfigResponse other = (GetResolverQueryLogConfigResponse) obj;
        return Objects.equals(resolverQueryLogConfig(), other.resolverQueryLogConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResolverQueryLogConfigResponse").add("ResolverQueryLogConfig", resolverQueryLogConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverQueryLogConfig":
            return Optional.ofNullable(clazz.cast(resolverQueryLogConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetResolverQueryLogConfigResponse, T> g) {
        return obj -> g.apply((GetResolverQueryLogConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResolverQueryLogConfigResponse> {
        /**
         * <p>
         * Information about the Resolver query logging configuration that you specified in a
         * <code>GetQueryLogConfig</code> request.
         * </p>
         * 
         * @param resolverQueryLogConfig
         *        Information about the Resolver query logging configuration that you specified in a
         *        <code>GetQueryLogConfig</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverQueryLogConfig(ResolverQueryLogConfig resolverQueryLogConfig);

        /**
         * <p>
         * Information about the Resolver query logging configuration that you specified in a
         * <code>GetQueryLogConfig</code> request.
         * </p>
         * This is a convenience that creates an instance of the {@link ResolverQueryLogConfig.Builder} avoiding the
         * need to create one manually via {@link ResolverQueryLogConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResolverQueryLogConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #resolverQueryLogConfig(ResolverQueryLogConfig)}.
         * 
         * @param resolverQueryLogConfig
         *        a consumer that will call methods on {@link ResolverQueryLogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolverQueryLogConfig(ResolverQueryLogConfig)
         */
        default Builder resolverQueryLogConfig(Consumer<ResolverQueryLogConfig.Builder> resolverQueryLogConfig) {
            return resolverQueryLogConfig(ResolverQueryLogConfig.builder().applyMutation(resolverQueryLogConfig).build());
        }
    }

    static final class BuilderImpl extends Route53ResolverResponse.BuilderImpl implements Builder {
        private ResolverQueryLogConfig resolverQueryLogConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResolverQueryLogConfigResponse model) {
            super(model);
            resolverQueryLogConfig(model.resolverQueryLogConfig);
        }

        public final ResolverQueryLogConfig.Builder getResolverQueryLogConfig() {
            return resolverQueryLogConfig != null ? resolverQueryLogConfig.toBuilder() : null;
        }

        @Override
        public final Builder resolverQueryLogConfig(ResolverQueryLogConfig resolverQueryLogConfig) {
            this.resolverQueryLogConfig = resolverQueryLogConfig;
            return this;
        }

        public final void setResolverQueryLogConfig(ResolverQueryLogConfig.BuilderImpl resolverQueryLogConfig) {
            this.resolverQueryLogConfig = resolverQueryLogConfig != null ? resolverQueryLogConfig.build() : null;
        }

        @Override
        public GetResolverQueryLogConfigResponse build() {
            return new GetResolverQueryLogConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
