/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * High-level information for a firewall rule group. A firewall rule group is a collection of rules that DNS Firewall
 * uses to filter DNS network traffic for a VPC. To retrieve the rules for the rule group, call
 * <a>ListFirewallRules</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallRuleGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallRuleGroup.Builder, FirewallRuleGroup> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FirewallRuleGroup::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(FirewallRuleGroup::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FirewallRuleGroup::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> RULE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleCount").getter(getter(FirewallRuleGroup::ruleCount)).setter(setter(Builder::ruleCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleCount").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FirewallRuleGroup::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(FirewallRuleGroup::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(FirewallRuleGroup::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(FirewallRuleGroup::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareStatus").getter(getter(FirewallRuleGroup::shareStatusAsString))
            .setter(setter(Builder::shareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(FirewallRuleGroup::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModificationTime").getter(getter(FirewallRuleGroup::modificationTime))
            .setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, RULE_COUNT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, OWNER_ID_FIELD, CREATOR_REQUEST_ID_FIELD,
            SHARE_STATUS_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final Integer ruleCount;

    private final String status;

    private final String statusMessage;

    private final String ownerId;

    private final String creatorRequestId;

    private final String shareStatus;

    private final String creationTime;

    private final String modificationTime;

    private FirewallRuleGroup(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.ruleCount = builder.ruleCount;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.ownerId = builder.ownerId;
        this.creatorRequestId = builder.creatorRequestId;
        this.shareStatus = builder.shareStatus;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    /**
     * <p>
     * The ID of the rule group.
     * </p>
     * 
     * @return The ID of the rule group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the rule group.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the rule group.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the rule group.
     * </p>
     * 
     * @return The name of the rule group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The number of rules in the rule group.
     * </p>
     * 
     * @return The number of rules in the rule group.
     */
    public final Integer ruleCount() {
        return ruleCount;
    }

    /**
     * <p>
     * The status of the domain list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallRuleGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain list.
     * @see FirewallRuleGroupStatus
     */
    public final FirewallRuleGroupStatus status() {
        return FirewallRuleGroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the domain list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallRuleGroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain list.
     * @see FirewallRuleGroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the status of the rule group, if available.
     * </p>
     * 
     * @return Additional information about the status of the rule group, if available.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The AWS account ID for the account that created the rule group. When a rule group is shared with your account,
     * this is the account that has shared the rule group with you.
     * </p>
     * 
     * @return The AWS account ID for the account that created the rule group. When a rule group is shared with your
     *         account, this is the account that has shared the rule group with you.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk
     * of executing the operation twice. This can be any unique string, for example, a timestamp.
     * </p>
     * 
     * @return A unique string defined by you to identify the request. This allows you to retry failed requests without
     *         the risk of executing the operation twice. This can be any unique string, for example, a timestamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another AWS
     * account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Whether the rule group is shared with other AWS accounts, or was shared with the current account by
     *         another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * @see ShareStatus
     */
    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(shareStatus);
    }

    /**
     * <p>
     * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another AWS
     * account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Whether the rule group is shared with other AWS accounts, or was shared with the current account by
     *         another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
     * @see ShareStatus
     */
    public final String shareStatusAsString() {
        return shareStatus;
    }

    /**
     * <p>
     * The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the rule group was created, in Unix time format and Coordinated Universal Time
     *         (UTC).
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time
     * (UTC).
     * </p>
     * 
     * @return The date and time that the rule group was last modified, in Unix time format and Coordinated Universal
     *         Time (UTC).
     */
    public final String modificationTime() {
        return modificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ruleCount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(shareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallRuleGroup)) {
            return false;
        }
        FirewallRuleGroup other = (FirewallRuleGroup) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(ruleCount(), other.ruleCount()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(shareStatusAsString(), other.shareStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modificationTime(), other.modificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallRuleGroup").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("RuleCount", ruleCount()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("OwnerId", ownerId()).add("CreatorRequestId", creatorRequestId()).add("ShareStatus", shareStatusAsString())
                .add("CreationTime", creationTime()).add("ModificationTime", modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RuleCount":
            return Optional.ofNullable(clazz.cast(ruleCount()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "ShareStatus":
            return Optional.ofNullable(clazz.cast(shareStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallRuleGroup, T> g) {
        return obj -> g.apply((FirewallRuleGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallRuleGroup> {
        /**
         * <p>
         * The ID of the rule group.
         * </p>
         * 
         * @param id
         *        The ID of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the rule group.
         * </p>
         * 
         * @param arn
         *        The ARN (Amazon Resource Name) of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the rule group.
         * </p>
         * 
         * @param name
         *        The name of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of rules in the rule group.
         * </p>
         * 
         * @param ruleCount
         *        The number of rules in the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleCount(Integer ruleCount);

        /**
         * <p>
         * The status of the domain list.
         * </p>
         * 
         * @param status
         *        The status of the domain list.
         * @see FirewallRuleGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleGroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the domain list.
         * </p>
         * 
         * @param status
         *        The status of the domain list.
         * @see FirewallRuleGroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleGroupStatus
         */
        Builder status(FirewallRuleGroupStatus status);

        /**
         * <p>
         * Additional information about the status of the rule group, if available.
         * </p>
         * 
         * @param statusMessage
         *        Additional information about the status of the rule group, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The AWS account ID for the account that created the rule group. When a rule group is shared with your
         * account, this is the account that has shared the rule group with you.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID for the account that created the rule group. When a rule group is shared with your
         *        account, this is the account that has shared the rule group with you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the
         * risk of executing the operation twice. This can be any unique string, for example, a timestamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string defined by you to identify the request. This allows you to retry failed requests
         *        without the risk of executing the operation twice. This can be any unique string, for example, a
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another
         * AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * </p>
         * 
         * @param shareStatus
         *        Whether the rule group is shared with other AWS accounts, or was shared with the current account by
         *        another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(String shareStatus);

        /**
         * <p>
         * Whether the rule group is shared with other AWS accounts, or was shared with the current account by another
         * AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * </p>
         * 
         * @param shareStatus
         *        Whether the rule group is shared with other AWS accounts, or was shared with the current account by
         *        another AWS account. Sharing is configured through AWS Resource Access Manager (AWS RAM).
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(ShareStatus shareStatus);

        /**
         * <p>
         * The date and time that the rule group was created, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the rule group was created, in Unix time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The date and time that the rule group was last modified, in Unix time format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the rule group was last modified, in Unix time format and Coordinated Universal
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(String modificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private Integer ruleCount;

        private String status;

        private String statusMessage;

        private String ownerId;

        private String creatorRequestId;

        private String shareStatus;

        private String creationTime;

        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallRuleGroup model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            ruleCount(model.ruleCount);
            status(model.status);
            statusMessage(model.statusMessage);
            ownerId(model.ownerId);
            creatorRequestId(model.creatorRequestId);
            shareStatus(model.shareStatus);
            creationTime(model.creationTime);
            modificationTime(model.modificationTime);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getRuleCount() {
            return ruleCount;
        }

        @Override
        public final Builder ruleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
            return this;
        }

        public final void setRuleCount(Integer ruleCount) {
            this.ruleCount = ruleCount;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallRuleGroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getShareStatus() {
            return shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModificationTime() {
            return modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public FirewallRuleGroup build() {
            return new FirewallRuleGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
