/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * High level information about a list of firewall domains for use in a <a>FirewallRule</a>. This is returned by
 * <a>GetFirewallDomainList</a>.
 * </p>
 * <p>
 * To retrieve the domains that are defined for this domain list, call <a>ListFirewallDomains</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallDomainList implements SdkPojo, Serializable,
        ToCopyableBuilder<FirewallDomainList.Builder, FirewallDomainList> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FirewallDomainList::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(FirewallDomainList::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(FirewallDomainList::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> DOMAIN_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DomainCount").getter(getter(FirewallDomainList::domainCount)).setter(setter(Builder::domainCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainCount").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(FirewallDomainList::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(FirewallDomainList::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> MANAGED_OWNER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagedOwnerName").getter(getter(FirewallDomainList::managedOwnerName))
            .setter(setter(Builder::managedOwnerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedOwnerName").build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId").getter(getter(FirewallDomainList::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()).build();

    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationTime").getter(getter(FirewallDomainList::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModificationTime").getter(getter(FirewallDomainList::modificationTime))
            .setter(setter(Builder::modificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DOMAIN_COUNT_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, MANAGED_OWNER_NAME_FIELD,
            CREATOR_REQUEST_ID_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final Integer domainCount;

    private final String status;

    private final String statusMessage;

    private final String managedOwnerName;

    private final String creatorRequestId;

    private final String creationTime;

    private final String modificationTime;

    private FirewallDomainList(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.domainCount = builder.domainCount;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.managedOwnerName = builder.managedOwnerName;
        this.creatorRequestId = builder.creatorRequestId;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
    }

    /**
     * <p>
     * The ID of the domain list.
     * </p>
     * 
     * @return The ID of the domain list.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the firewall domain list.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the firewall domain list.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the domain list.
     * </p>
     * 
     * @return The name of the domain list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The number of domain names that are specified in the domain list.
     * </p>
     * 
     * @return The number of domain names that are specified in the domain list.
     */
    public final Integer domainCount() {
        return domainCount;
    }

    /**
     * <p>
     * The status of the domain list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallDomainListStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain list.
     * @see FirewallDomainListStatus
     */
    public final FirewallDomainListStatus status() {
        return FirewallDomainListStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the domain list.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FirewallDomainListStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the domain list.
     * @see FirewallDomainListStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the status of the list, if available.
     * </p>
     * 
     * @return Additional information about the status of the list, if available.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The owner of the list, used only for lists that are not managed by you. For example, the managed domain list
     * <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name
     * <code>Route 53 Resolver DNS Firewall</code>.
     * </p>
     * 
     * @return The owner of the list, used only for lists that are not managed by you. For example, the managed domain
     *         list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name
     *         <code>Route 53 Resolver DNS Firewall</code>.
     */
    public final String managedOwnerName() {
        return managedOwnerName;
    }

    /**
     * <p>
     * A unique string defined by you to identify the request. This allows you to retry failed requests without the risk
     * of executing the operation twice. This can be any unique string, for example, a timestamp.
     * </p>
     * 
     * @return A unique string defined by you to identify the request. This allows you to retry failed requests without
     *         the risk of executing the operation twice. This can be any unique string, for example, a timestamp.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    /**
     * <p>
     * The date and time that the domain list was created, in Unix time format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return The date and time that the domain list was created, in Unix time format and Coordinated Universal Time
     *         (UTC).
     */
    public final String creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the domain list was last modified, in Unix time format and Coordinated Universal Time
     * (UTC).
     * </p>
     * 
     * @return The date and time that the domain list was last modified, in Unix time format and Coordinated Universal
     *         Time (UTC).
     */
    public final String modificationTime() {
        return modificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(domainCount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(managedOwnerName());
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallDomainList)) {
            return false;
        }
        FirewallDomainList other = (FirewallDomainList) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(domainCount(), other.domainCount()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(managedOwnerName(), other.managedOwnerName())
                && Objects.equals(creatorRequestId(), other.creatorRequestId())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(modificationTime(), other.modificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallDomainList").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("DomainCount", domainCount()).add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("ManagedOwnerName", managedOwnerName()).add("CreatorRequestId", creatorRequestId())
                .add("CreationTime", creationTime()).add("ModificationTime", modificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DomainCount":
            return Optional.ofNullable(clazz.cast(domainCount()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "ManagedOwnerName":
            return Optional.ofNullable(clazz.cast(managedOwnerName()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModificationTime":
            return Optional.ofNullable(clazz.cast(modificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallDomainList, T> g) {
        return obj -> g.apply((FirewallDomainList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallDomainList> {
        /**
         * <p>
         * The ID of the domain list.
         * </p>
         * 
         * @param id
         *        The ID of the domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the firewall domain list.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the firewall domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the domain list.
         * </p>
         * 
         * @param name
         *        The name of the domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of domain names that are specified in the domain list.
         * </p>
         * 
         * @param domainCount
         *        The number of domain names that are specified in the domain list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainCount(Integer domainCount);

        /**
         * <p>
         * The status of the domain list.
         * </p>
         * 
         * @param status
         *        The status of the domain list.
         * @see FirewallDomainListStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallDomainListStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the domain list.
         * </p>
         * 
         * @param status
         *        The status of the domain list.
         * @see FirewallDomainListStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallDomainListStatus
         */
        Builder status(FirewallDomainListStatus status);

        /**
         * <p>
         * Additional information about the status of the list, if available.
         * </p>
         * 
         * @param statusMessage
         *        Additional information about the status of the list, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The owner of the list, used only for lists that are not managed by you. For example, the managed domain list
         * <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name
         * <code>Route 53 Resolver DNS Firewall</code>.
         * </p>
         * 
         * @param managedOwnerName
         *        The owner of the list, used only for lists that are not managed by you. For example, the managed
         *        domain list <code>AWSManagedDomainsMalwareDomainList</code> has the managed owner name
         *        <code>Route 53 Resolver DNS Firewall</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedOwnerName(String managedOwnerName);

        /**
         * <p>
         * A unique string defined by you to identify the request. This allows you to retry failed requests without the
         * risk of executing the operation twice. This can be any unique string, for example, a timestamp.
         * </p>
         * 
         * @param creatorRequestId
         *        A unique string defined by you to identify the request. This allows you to retry failed requests
         *        without the risk of executing the operation twice. This can be any unique string, for example, a
         *        timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        /**
         * <p>
         * The date and time that the domain list was created, in Unix time format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param creationTime
         *        The date and time that the domain list was created, in Unix time format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(String creationTime);

        /**
         * <p>
         * The date and time that the domain list was last modified, in Unix time format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param modificationTime
         *        The date and time that the domain list was last modified, in Unix time format and Coordinated
         *        Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modificationTime(String modificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private Integer domainCount;

        private String status;

        private String statusMessage;

        private String managedOwnerName;

        private String creatorRequestId;

        private String creationTime;

        private String modificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallDomainList model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            domainCount(model.domainCount);
            status(model.status);
            statusMessage(model.statusMessage);
            managedOwnerName(model.managedOwnerName);
            creatorRequestId(model.creatorRequestId);
            creationTime(model.creationTime);
            modificationTime(model.modificationTime);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getDomainCount() {
            return domainCount;
        }

        @Override
        public final Builder domainCount(Integer domainCount) {
            this.domainCount = domainCount;
            return this;
        }

        public final void setDomainCount(Integer domainCount) {
            this.domainCount = domainCount;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FirewallDomainListStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final String getManagedOwnerName() {
            return managedOwnerName;
        }

        @Override
        public final Builder managedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
            return this;
        }

        public final void setManagedOwnerName(String managedOwnerName) {
            this.managedOwnerName = managedOwnerName;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getModificationTime() {
            return modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public FirewallDomainList build() {
            return new FirewallDomainList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
