/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of the firewall behavior provided by DNS Firewall for a single Amazon virtual private cloud (VPC).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FirewallConfig implements SdkPojo, Serializable, ToCopyableBuilder<FirewallConfig.Builder, FirewallConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(FirewallConfig::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(FirewallConfig::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(FirewallConfig::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> FIREWALL_FAIL_OPEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallFailOpen").getter(getter(FirewallConfig::firewallFailOpenAsString))
            .setter(setter(Builder::firewallFailOpen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallFailOpen").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RESOURCE_ID_FIELD,
            OWNER_ID_FIELD, FIREWALL_FAIL_OPEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String resourceId;

    private final String ownerId;

    private final String firewallFailOpen;

    private FirewallConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.resourceId = builder.resourceId;
        this.ownerId = builder.ownerId;
        this.firewallFailOpen = builder.firewallFailOpen;
    }

    /**
     * <p>
     * The Id of the firewall configuration.
     * </p>
     * 
     * @return The Id of the firewall configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the VPC that this firewall configuration applies to.
     * </p>
     * 
     * @return The ID of the VPC that this firewall configuration applies to.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the VPC that this firewall configuration applies to.
     * </p>
     * 
     * @return The AWS account ID of the owner of the VPC that this firewall configuration applies to.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS Firewall
     * fails to receive a reply.
     * </p>
     * <ul>
     * <li>
     * <p>
     * By default, fail open is disabled, which means the failure mode is closed. This approach favors security over
     * availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you enable this option, the failure mode is open. This approach favors availability over security. DNS
     * Firewall allows queries to proceed if it is unable to properly evaluate them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #firewallFailOpen}
     * will return {@link FirewallFailOpenStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #firewallFailOpenAsString}.
     * </p>
     * 
     * @return Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS
     *         Firewall fails to receive a reply. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         By default, fail open is disabled, which means the failure mode is closed. This approach favors security
     *         over availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you enable this option, the failure mode is open. This approach favors availability over security. DNS
     *         Firewall allows queries to proceed if it is unable to properly evaluate them.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     * @see FirewallFailOpenStatus
     */
    public final FirewallFailOpenStatus firewallFailOpen() {
        return FirewallFailOpenStatus.fromValue(firewallFailOpen);
    }

    /**
     * <p>
     * Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS Firewall
     * fails to receive a reply.
     * </p>
     * <ul>
     * <li>
     * <p>
     * By default, fail open is disabled, which means the failure mode is closed. This approach favors security over
     * availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you enable this option, the failure mode is open. This approach favors availability over security. DNS
     * Firewall allows queries to proceed if it is unable to properly evaluate them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #firewallFailOpen}
     * will return {@link FirewallFailOpenStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #firewallFailOpenAsString}.
     * </p>
     * 
     * @return Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS
     *         Firewall fails to receive a reply. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         By default, fail open is disabled, which means the failure mode is closed. This approach favors security
     *         over availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you enable this option, the failure mode is open. This approach favors availability over security. DNS
     *         Firewall allows queries to proceed if it is unable to properly evaluate them.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
     * @see FirewallFailOpenStatus
     */
    public final String firewallFailOpenAsString() {
        return firewallFailOpen;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(firewallFailOpenAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallConfig)) {
            return false;
        }
        FirewallConfig other = (FirewallConfig) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(ownerId(), other.ownerId())
                && Objects.equals(firewallFailOpenAsString(), other.firewallFailOpenAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FirewallConfig").add("Id", id()).add("ResourceId", resourceId()).add("OwnerId", ownerId())
                .add("FirewallFailOpen", firewallFailOpenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "FirewallFailOpen":
            return Optional.ofNullable(clazz.cast(firewallFailOpenAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirewallConfig, T> g) {
        return obj -> g.apply((FirewallConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FirewallConfig> {
        /**
         * <p>
         * The Id of the firewall configuration.
         * </p>
         * 
         * @param id
         *        The Id of the firewall configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the VPC that this firewall configuration applies to.
         * </p>
         * 
         * @param resourceId
         *        The ID of the VPC that this firewall configuration applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The AWS account ID of the owner of the VPC that this firewall configuration applies to.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the owner of the VPC that this firewall configuration applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS
         * Firewall fails to receive a reply.
         * </p>
         * <ul>
         * <li>
         * <p>
         * By default, fail open is disabled, which means the failure mode is closed. This approach favors security over
         * availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you enable this option, the failure mode is open. This approach favors availability over security. DNS
         * Firewall allows queries to proceed if it is unable to properly evaluate them.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         * </p>
         * 
         * @param firewallFailOpen
         *        Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS
         *        Firewall fails to receive a reply. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        By default, fail open is disabled, which means the failure mode is closed. This approach favors
         *        security over availability. DNS Firewall returns a failure error when it is unable to properly
         *        evaluate a query.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you enable this option, the failure mode is open. This approach favors availability over security.
         *        DNS Firewall allows queries to proceed if it is unable to properly evaluate them.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         * @see FirewallFailOpenStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallFailOpenStatus
         */
        Builder firewallFailOpen(String firewallFailOpen);

        /**
         * <p>
         * Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS
         * Firewall fails to receive a reply.
         * </p>
         * <ul>
         * <li>
         * <p>
         * By default, fail open is disabled, which means the failure mode is closed. This approach favors security over
         * availability. DNS Firewall returns a failure error when it is unable to properly evaluate a query.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you enable this option, the failure mode is open. This approach favors availability over security. DNS
         * Firewall allows queries to proceed if it is unable to properly evaluate them.
         * </p>
         * </li>
         * </ul>
         * <p>
         * This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         * </p>
         * 
         * @param firewallFailOpen
         *        Determines how DNS Firewall operates during failures, for example when all traffic that is sent to DNS
         *        Firewall fails to receive a reply. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        By default, fail open is disabled, which means the failure mode is closed. This approach favors
         *        security over availability. DNS Firewall returns a failure error when it is unable to properly
         *        evaluate a query.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you enable this option, the failure mode is open. This approach favors availability over security.
         *        DNS Firewall allows queries to proceed if it is unable to properly evaluate them.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        This behavior is only enforced for VPCs that have at least one DNS Firewall rule group association.
         * @see FirewallFailOpenStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallFailOpenStatus
         */
        Builder firewallFailOpen(FirewallFailOpenStatus firewallFailOpen);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String resourceId;

        private String ownerId;

        private String firewallFailOpen;

        private BuilderImpl() {
        }

        private BuilderImpl(FirewallConfig model) {
            id(model.id);
            resourceId(model.resourceId);
            ownerId(model.ownerId);
            firewallFailOpen(model.firewallFailOpen);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getFirewallFailOpen() {
            return firewallFailOpen;
        }

        @Override
        public final Builder firewallFailOpen(String firewallFailOpen) {
            this.firewallFailOpen = firewallFailOpen;
            return this;
        }

        @Override
        public final Builder firewallFailOpen(FirewallFailOpenStatus firewallFailOpen) {
            this.firewallFailOpen(firewallFailOpen == null ? null : firewallFailOpen.toString());
            return this;
        }

        public final void setFirewallFailOpen(String firewallFailOpen) {
            this.firewallFailOpen = firewallFailOpen;
        }

        @Override
        public FirewallConfig build() {
            return new FirewallConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
