/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53resolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateResolverEndpointIpAddressRequest extends Route53ResolverRequest implements
        ToCopyableBuilder<AssociateResolverEndpointIpAddressRequest.Builder, AssociateResolverEndpointIpAddressRequest> {
    private static final SdkField<String> RESOLVER_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResolverEndpointId").getter(getter(AssociateResolverEndpointIpAddressRequest::resolverEndpointId))
            .setter(setter(Builder::resolverEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolverEndpointId").build())
            .build();

    private static final SdkField<IpAddressUpdate> IP_ADDRESS_FIELD = SdkField
            .<IpAddressUpdate> builder(MarshallingType.SDK_POJO).memberName("IpAddress")
            .getter(getter(AssociateResolverEndpointIpAddressRequest::ipAddress)).setter(setter(Builder::ipAddress))
            .constructor(IpAddressUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_ENDPOINT_ID_FIELD,
            IP_ADDRESS_FIELD));

    private final String resolverEndpointId;

    private final IpAddressUpdate ipAddress;

    private AssociateResolverEndpointIpAddressRequest(BuilderImpl builder) {
        super(builder);
        this.resolverEndpointId = builder.resolverEndpointId;
        this.ipAddress = builder.ipAddress;
    }

    /**
     * <p>
     * The ID of the Resolver endpoint that you want to associate IP addresses with.
     * </p>
     * 
     * @return The ID of the Resolver endpoint that you want to associate IP addresses with.
     */
    public final String resolverEndpointId() {
        return resolverEndpointId;
    }

    /**
     * <p>
     * Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID,
     * Resolver chooses an IP address for you from the available IPs in the specified subnet.
     * </p>
     * 
     * @return Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a
     *         subnet ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.
     */
    public final IpAddressUpdate ipAddress() {
        return ipAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolverEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateResolverEndpointIpAddressRequest)) {
            return false;
        }
        AssociateResolverEndpointIpAddressRequest other = (AssociateResolverEndpointIpAddressRequest) obj;
        return Objects.equals(resolverEndpointId(), other.resolverEndpointId()) && Objects.equals(ipAddress(), other.ipAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateResolverEndpointIpAddressRequest").add("ResolverEndpointId", resolverEndpointId())
                .add("IpAddress", ipAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResolverEndpointId":
            return Optional.ofNullable(clazz.cast(resolverEndpointId()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateResolverEndpointIpAddressRequest, T> g) {
        return obj -> g.apply((AssociateResolverEndpointIpAddressRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53ResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateResolverEndpointIpAddressRequest> {
        /**
         * <p>
         * The ID of the Resolver endpoint that you want to associate IP addresses with.
         * </p>
         * 
         * @param resolverEndpointId
         *        The ID of the Resolver endpoint that you want to associate IP addresses with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverEndpointId(String resolverEndpointId);

        /**
         * <p>
         * Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet
         * ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.
         * </p>
         * 
         * @param ipAddress
         *        Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a
         *        subnet ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(IpAddressUpdate ipAddress);

        /**
         * <p>
         * Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet
         * ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link IpAddressUpdate.Builder} avoiding the need to
         * create one manually via {@link IpAddressUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link IpAddressUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #ipAddress(IpAddressUpdate)}.
         * 
         * @param ipAddress
         *        a consumer that will call methods on {@link IpAddressUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipAddress(IpAddressUpdate)
         */
        default Builder ipAddress(Consumer<IpAddressUpdate.Builder> ipAddress) {
            return ipAddress(IpAddressUpdate.builder().applyMutation(ipAddress).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53ResolverRequest.BuilderImpl implements Builder {
        private String resolverEndpointId;

        private IpAddressUpdate ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateResolverEndpointIpAddressRequest model) {
            super(model);
            resolverEndpointId(model.resolverEndpointId);
            ipAddress(model.ipAddress);
        }

        public final String getResolverEndpointId() {
            return resolverEndpointId;
        }

        @Override
        public final Builder resolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
            return this;
        }

        public final void setResolverEndpointId(String resolverEndpointId) {
            this.resolverEndpointId = resolverEndpointId;
        }

        public final IpAddressUpdate.Builder getIpAddress() {
            return ipAddress != null ? ipAddress.toBuilder() : null;
        }

        @Override
        public final Builder ipAddress(IpAddressUpdate ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(IpAddressUpdate.BuilderImpl ipAddress) {
            this.ipAddress = ipAddress != null ? ipAddress.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateResolverEndpointIpAddressRequest build() {
            return new AssociateResolverEndpointIpAddressRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
