/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53profiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53profiles.Route53ProfilesClient;
import software.amazon.awssdk.services.route53profiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53profiles.model.ListProfileAssociationsRequest;
import software.amazon.awssdk.services.route53profiles.model.ListProfileAssociationsResponse;
import software.amazon.awssdk.services.route53profiles.model.ProfileAssociation;

public class ListProfileAssociationsIterable
implements SdkIterable<ListProfileAssociationsResponse> {
    private final Route53ProfilesClient client;
    private final ListProfileAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProfileAssociationsIterable(Route53ProfilesClient client, ListProfileAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProfileAssociationsResponseFetcher();
    }

    public Iterator<ListProfileAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProfileAssociation> profileAssociations() {
        Function<ListProfileAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileAssociations() != null) {
                return response.profileAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListProfileAssociationsResponseFetcher
    implements SyncPageFetcher<ListProfileAssociationsResponse> {
        private ListProfileAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListProfileAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProfileAssociationsResponse nextPage(ListProfileAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListProfileAssociationsIterable.this.client.listProfileAssociations(ListProfileAssociationsIterable.this.firstRequest);
            }
            return ListProfileAssociationsIterable.this.client.listProfileAssociations((ListProfileAssociationsRequest)((Object)ListProfileAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

