/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class KeySigningKeysCopier {
    static List<KeySigningKey> copy(Collection<? extends KeySigningKey> keySigningKeysParam) {
        List<KeySigningKey> list;
        if (keySigningKeysParam == null || keySigningKeysParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<KeySigningKey> modifiableList = new ArrayList<>(keySigningKeysParam.size());
            keySigningKeysParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<KeySigningKey> copyFromBuilder(Collection<? extends KeySigningKey.Builder> keySigningKeysParam) {
        List<KeySigningKey> list;
        if (keySigningKeysParam == null || keySigningKeysParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<KeySigningKey> modifiableList = new ArrayList<>(keySigningKeysParam.size());
            keySigningKeysParam.forEach(entry -> {
                KeySigningKey member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<KeySigningKey.Builder> copyToBuilder(Collection<? extends KeySigningKey> keySigningKeysParam) {
        List<KeySigningKey.Builder> list;
        if (keySigningKeysParam == null || keySigningKeysParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<KeySigningKey.Builder> modifiableList = new ArrayList<>(keySigningKeysParam.size());
            keySigningKeysParam.forEach(entry -> {
                KeySigningKey.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
